package com.inqmy.ats.gui;

import com.inqmy.ats.system.tools.MessageManager;
import com.inqmy.ats.system.Engine;
import com.inqmy.ats.gui.tools.MessageUtil;

import javax.swing.*;

/**
 * 
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 
 */
public class MessageManagerImpl implements MessageManager{
  JFrame frame;
  
  public MessageManagerImpl(JFrame frame){
    this.frame = frame;
  }
  
  //invoked if some kind of message have to be processed
  public void messageReceived(String message , byte type) {
    switch (type) {
      case Engine.FATAL_MESSAGE : {
        JOptionPane.showMessageDialog(frame , message , "error" , JOptionPane.ERROR_MESSAGE );
        break;
      }
      case Engine.WARNING_MESSAGE : {
        JOptionPane.showMessageDialog(frame , message , "warrning" , JOptionPane.WARNING_MESSAGE  );
        break;
      }
      case Engine.INFO_MESSAGE : {
        MessageUtil.showDialog(message , frame , JOptionPane.INFORMATION_MESSAGE , "finish");
        //JOptionPane.showMessageDialog(frame , message , "info" , JOptionPane.INFORMATION_MESSAGE  );
        break;
      }

      default : break;
    }
  }
}
