package com.inqmy.ats.gui;

import javax.swing.*;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;
import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

import com.inqmy.ats.system.communication.RemoteInvokeException;
import com.inqmy.ats.system.communication.client.CommunicationContext;
import com.inqmy.ats.system.communication.client.CommunicationContextImpl;
import com.inqmy.ats.system.communication.client.RegisterListener;

import com.inqmy.ats.system.tools.*;

import com.inqmy.ats.system.*;

import com.inqmy.ats.boot.*;
import com.inqmy.ats.gui.tools.VisualOutputStream;
import com.sap.tc.logging.Location;

/**
 *
 *
 * @author Tzvetan Georgiev (tsvetan.georgiev@sap.com)
 * @version 1.0
 */

public class MainFrameView extends JFrame implements WindowListener , ActionListener , ChangeListener ,RegisterListener {
  
  public final static String CLEAR_SYSTEM_PANEL_COMMAND = "clear.system.action";
  public final static String AUTO_SCROLL_COMMAND = "auto.scroll.action";

  public static final String SYSTEM_TITLE = "ATS";
 
  public static final String SAVE_ACTION = "save.action";
  public static final String SAVE_AS_ACTION = "save.as.action";
  public static final String OPEN_ACTION = "open.action";
  public static final String EXIT_ACTION = "exit.action";

  private JToolBar toolBar;
  private JTabbedPane tabbedPane;

  private VisualOutputStream visualOutput;
  private boolean autoScroll = false;
  private JButton autoScrollButton;

  private JTextArea text;
  public static int x = 0;
  public static int y = 0;

  private static Hashtable providerLoaders;
  private Hashtable guis;
  private Hashtable runtimes;
  private String[] allProviders;

  private File currentProfileFile;
  //private RuntimeControlInterface providerInterface;
  //private GUIRuntimeControlInterface gui;
  private EngineControl engineControl;
  private CommunicationContext communication;
  private JButton exitButton;

  private Object monitor = new Object();

  public MainFrameView(boolean isRemote) throws Exception {
    super(SYSTEM_TITLE + " - []");
    MessageManagerImpl mmanager = null;
    try {
      if(isRemote) {
        //adds console message manager
        CommonLog.addMessageManager(new ConsoleMessageManagerImpl());
      }
      //makes visual message manager implementation
      mmanager = new MessageManagerImpl(this);
      //adds to CommmonLog visual message manager
      CommonLog.addMessageManager(mmanager);
    } catch(Exception exc) {
      CommonLog.log("Error making visual message manager. Error is : ");
      exc.printStackTrace();
    }
    Engine engine = null;
    if(!isRemote) {
      Engine.initializeEngineStatic();
      engine = new Engine();
      engine.initialize(null);
      providerLoaders = new Hashtable();
    }

    communication = CoreContext.getCommunicationContext();
    communication.registerListener(this);
    //gets engine control object reference
    synchronized(monitor) {
      try {
        engineControl = (EngineControl)communication.getProxy("ENGINE_CONTROL");
      } catch(RemoteInvokeException rie) {
        CommonLog.log("Object not here now wait to register");
        monitor.wait();
        engineControl = (EngineControl)communication.getProxy("ENGINE_CONTROL");
      }
    }
    this.allProviders = engineControl.getAllProviderNames();
    if(isRemote) {
     //1 - register LogListener and passes it to server ( engineControl.addLogListener -> adds LogListener to CommonLog)
     // for transporting messages to client that are made on server.
     //2 - adds console Message Manager implementation to local CommonLog!
      try {
        LogListenerImpl listener = new LogListenerImpl();
        //register LogListener for remote messages transfering
        communication.registerObject("LogListener" , listener);
        //passes LogListsner to server for remote calls
        engineControl.addLogListener((LogListener)communication.getProxy("LogListener"));
      } catch(Exception exc){
        exc.printStackTrace();
      }
    } else {
      //now fill provider loaders hashtable....
      for (int i = 0 ; i < this.allProviders.length ;i++) {
        String prName = allProviders[i];
        CoreClassLoader loader = engine.getProviderLoader(prName);
        providerLoaders.put(engine.getProvider(prName).getClass().getName() , loader);
      }

    }
    guis = new Hashtable();
    runtimes = new Hashtable();
    for (int i = 0 ; i < this.allProviders.length ;i++) {
      try {
        String prName = allProviders[i];
        //gets reference to runtime control interface of ats provider
        RuntimeControlInterface providerInterface = engineControl.getProviderRuntimeControl(prName);
        runtimes.put(prName , providerInterface);
      } catch(RemoteInvokeException riexc){
        CommonLog.log("Can not get runtime control of provider!");
        riexc.printStackTrace();
      }
    }

    //initializing GUI...
    initView();
  }

  public void objectRegistered(String name, Object object) {
    if(name.equals("ENGINE_CONTROL")) {
      synchronized(monitor) {
       monitor.notify();
      }
    }
  }

  public void objectUnregistered(String name) {
  }

  private boolean initGui() {
    try {
      for(int i = 0 ; i < allProviders.length ; i++) {
        String prName = allProviders[i];
        String clName = engineControl.getCUIClassName(prName);
        if(clName != null){
          try {
             //loads provider gui class and makes instance.
            RuntimeControlInterface providerInterface = (RuntimeControlInterface)runtimes.get(prName);
            Class guiClass = ((ClassLoader)(providerLoaders.get(engineControl.getImplClassName(prName)))).loadClass(clName);
            GUIRuntimeControlInterface gui =(GUIRuntimeControlInterface)guiClass.newInstance();
            gui.setGUIContainer(this);

            gui.setControl(providerInterface);
            guis.put(prName , gui);
          } catch(Throwable thr){
            CommonLog.log("Can not load GUI : " + clName , Engine.FATAL_MESSAGE);
            CommonLog.log(thr);
          }
        }
      }
    } catch(Throwable thr) {
      CommonLog.log("Error in provider GUI initialization!Error : " + thr.getMessage() , Engine.FATAL_MESSAGE);
      CommonLog.log(thr);
    }
    return true;
  }

  private void initView() {
    //initialize providers GUI's
    boolean isInitialized = initGui();
        //-----------------------
    addWindowListener(this);
    try{
      this.setIconImage(createImage((java.awt.image.ImageProducer)((this.getClass().getClassLoader().getResource("ico.gif"))).getContent()));
    } catch(Exception nn) {
      nn.printStackTrace();
    }
    JPanel parent = new JPanel();
    setContentPane(parent);
    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    int screenx = (int)dim.getWidth();
    int screeny = (int)dim.getHeight();
    x = (int)(2*screenx/3);
    y = (int)(2*screeny/3);
    setLocation((int)(screenx/2 - x/2) , (int)(screeny/2 - y/2));
    setSize(x,y);

    toolBar = new JToolBar();
    parent.setLayout(new BorderLayout());
    parent.add(toolBar ,  BorderLayout.NORTH);

   /* if(isInitialized){
      JButton[] buttons = gui.getButtons();
      for (int i = 0 ; i < buttons.length ; i++) {
        toolBar.add(buttons[i]);
      }
      toolBar.addSeparator();
    }
     */
    exitButton = new JButton(new ImageIcon("../images/exit.gif"));
    exitButton.addActionListener(this);
    exitButton.setActionCommand(EXIT_ACTION);
    exitButton.setToolTipText("Exit");
    toolBar.add(exitButton);

    JPanel system = new JPanel(new GridBagLayout());
    text = new JTextArea();
    JPanel pan = new JPanel(new BorderLayout());
    JToolBar toolbar = new JToolBar();
    toolbar.setFloatable(false);
    autoScrollButton = new JButton(new ImageIcon("../images/scroll.gif"));
    autoScrollButton.setActionCommand(AUTO_SCROLL_COMMAND);
    autoScrollButton.addActionListener(this);
    autoScrollButton.setToolTipText("Enable aoutomatic scroll");
    JButton clearButton =  new JButton(new ImageIcon("../images/clear.gif"));
    clearButton.setToolTipText("Clear console");

    toolbar.add(autoScrollButton);
    toolbar.add(clearButton);

    clearButton.setActionCommand(CLEAR_SYSTEM_PANEL_COMMAND);
    clearButton.addActionListener(this);
    pan.add(toolbar , BorderLayout.WEST);

    system.add(pan , new GridBagConstraints(0, 0, 1, 1, 0, 0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    JScrollPane scroll = new JScrollPane(text);
    JScrollBar sb = scroll.getVerticalScrollBar();
    system.add(scroll , new GridBagConstraints(0, 1, 1, 1, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));

    visualOutput = new VisualOutputStream(text , sb , true);
    OutputStream os = visualOutput;

    SystemStreamWrapper out = ((PrintStreamLog)System.out).getOuputStream();
    SystemStreamWrapper errOut = ((PrintStreamLog)System.err).getOuputStream();
    out.setOutputStream(os);
    errOut.setOutputStream(os);
    /*
    OutputStream out = ((PrintStreamLog)System.out).getOuputStream();
    OutputStreamLog systemOut = (OutputStreamLog)out;
    systemOut.addConsoleStream(os);
    //CommonLog.setOutput(systemOut);
    //System.setOut(new PrintStream(systemOut, true));//redirect out

    OutputStream err = ((PrintStreamLog)System.err).getOuputStream();
    systemOut = (OutputStreamLog)err;
    systemOut.addConsoleStream(os);
    */
    //System.setErr(new PrintStream(systemOut, true));//redirect error

    //systemOut.setStreams(new OutputStream[]{os , System.out});
    //CommonLog.setOutput(systemOut);
    //System.setOut(new PrintStream(systemOut, true));//redirect out
    //systemOut = new OutputStreamLog();
    //systemOut.setStreams(new OutputStream[]{os , System.err});
    //System.setErr(new PrintStream(systemOut, true));//redirect error

    JMenu mainMenu = null;
    JMenuItem menuItem = null;
    JMenuBar menuBar = new JMenuBar();
    setJMenuBar(menuBar);

    mainMenu = new JMenu("File");
    mainMenu.setMnemonic(KeyEvent.VK_F);
    menuBar.add(mainMenu);

    menuItem = new JMenuItem("Open Setting Profile...");
    menuItem.setActionCommand(OPEN_ACTION);
    menuItem.addActionListener(this);
    mainMenu.add(menuItem);

    menuItem = new JMenuItem("Save Setting Profile");
    menuItem.setActionCommand(SAVE_ACTION);
    menuItem.addActionListener(this);
    mainMenu.add(menuItem);

    menuItem = new JMenuItem("Save Setting Profile As...");
    menuItem.setActionCommand(SAVE_AS_ACTION);
    menuItem.addActionListener(this);
    mainMenu.add(menuItem);

    menuItem = new JMenuItem("Exit");
    menuItem.setActionCommand(EXIT_ACTION);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_2, ActionEvent.ALT_MASK));
    menuItem.addActionListener(this);
    mainMenu.add(menuItem);


    tabbedPane = new JTabbedPane();
    tabbedPane.addChangeListener(this);

    //adds visual component for viewing logs through System.out writer
    tabbedPane.addTab("CONSOLE" , system);
    if(isInitialized) {
      for( int  i = 0 ;i < allProviders.length ; i++){
      try {
          //adds to ATS GUI container loaded ats provider gui
          String prov = allProviders[i];
          String name = ((RuntimeControlInterface)runtimes.get(prov)).getProviderName();
          JComponent component =  ((GUIRuntimeControlInterface)guis.get(prov)).getGUIControlComponent();
          GUIPanelWrapper gpw = new GUIPanelWrapper();
          gpw.setLayout(new BorderLayout());
          gpw.add(component , BorderLayout.CENTER);
          gpw.setWrapperComponent(component , prov);
          tabbedPane.addTab( name , gpw);
        } catch(Exception e){
          e.printStackTrace();
        }
      }
    }
    parent.add(tabbedPane ,  BorderLayout.CENTER);
  }

  public void showMessageDialog(String message) {
    JOptionPane.showMessageDialog(this , message);
  }

  public void clearConsole(){
    text.selectAll();
    text.replaceSelection("");
  }

  public void windowActivated(WindowEvent e) {
  }
  public void windowClosed(WindowEvent e) {

  }
  public void windowClosing(WindowEvent e) {
    System.exit(0);
  }
  public void windowDeactivated(WindowEvent e) {
  }
  public void windowDeiconified(WindowEvent e) {
  }
  public void windowIconified(WindowEvent e) {
  }
  public void windowOpened(WindowEvent e) {
  }

  public void actionPerformed(ActionEvent e) {
    String action = e.getActionCommand();
    if(action.equals(EXIT_ACTION)) {
      System.exit(0);
    } else if(action.equals(CLEAR_SYSTEM_PANEL_COMMAND)) {
      clearConsole();
    } else if(action.equals(AUTO_SCROLL_COMMAND)) {
      autoScroll = !autoScroll;
      visualOutput.setAutoScroll(autoScroll);
      if(autoScroll) {
        autoScrollButton.setToolTipText("Disable aoutomatic scroll");
      } else {
        autoScrollButton.setToolTipText("Enable aoutomatic scroll");
      }
    } else if(action.equals(SAVE_AS_ACTION)) {
      JFileChooser jfc = new JFileChooser(new File("."));
      int res = jfc.showSaveDialog(this);
      saveProjectToFile(res , jfc.getSelectedFile());
    } else if(action.equals(SAVE_ACTION)) {
      if(currentProfileFile != null){
        saveProjectToFile(JFileChooser.APPROVE_OPTION  , currentProfileFile);
      } else {
        JFileChooser jfc = new JFileChooser(new File("."));
        int res = jfc.showSaveDialog(this);
        saveProjectToFile(res , jfc.getSelectedFile());
      }
    } else if (action.equals(OPEN_ACTION)) {
      JFileChooser jfc = new JFileChooser(new File("."));
      int res = jfc.showOpenDialog(this);
      File temp = jfc.getSelectedFile();
      switch (res ) {
        case JFileChooser.APPROVE_OPTION : {
          try{
            Hashtable ser = (Hashtable)Utilities.deserializeFromFile(temp);
            for (int i =0 ; i < allProviders.length ; i++) {
              String prName = allProviders[i];
              try {
                ((GUIRuntimeControlInterface)guis.get(prName)).setSettingEnvironment((Serializable)ser.get(prName));
              } catch(Exception exc){
                 exc.printStackTrace();
              }
            }
            currentProfileFile = temp;
            this.setTitle(SYSTEM_TITLE + " - ["+temp.getName()+"]");
          } catch(Exception exc) {
            exc.printStackTrace();
            currentProfileFile = null;
            showMessageDialog("Invalid profile setting file");
          }
          break;
        }
        case JFileChooser.CANCEL_OPTION :{
          break;
        }
        case JFileChooser.ERROR_OPTION : {
          break;
        }
        default : break;
      }
    }
  }
  private void saveProjectToFile(int res , File f)  {
    switch (res ) {
      case JFileChooser.APPROVE_OPTION : {
        try{
            Hashtable ser = new Hashtable();
            for (int i =0 ; i < allProviders.length ; i++) {
              String prName = allProviders[i];
              try {
                Object settings = ((GUIRuntimeControlInterface)guis.get(prName)).getSettingEnvironment();
                ser.put(prName , settings);
              } catch(Exception exc){
                 exc.printStackTrace();
              }
            }

          currentProfileFile = f;
          this.setTitle(SYSTEM_TITLE + " - ["+f.getName()+"]");
          Utilities.serializeToFile(ser ,f);
        } catch(Exception exc) {
          exc.printStackTrace();
          currentProfileFile = null;
          showMessageDialog("Invalid profile setting file");
        }
        break;
      }
      case JFileChooser.CANCEL_OPTION :{
        break;
      }
      case JFileChooser.ERROR_OPTION : {
        break;
      }
      default : break;
    }
  }
  public static void main(String[] args) throws Exception {
    boolean isRemote = false;
    if(args.length > 0 && args[0].equalsIgnoreCase("-r")) {
      isRemote = true;
    }
    if(isRemote)initializeStatic();

    try {
      MainFrameView view = new MainFrameView(isRemote);
      view.show();
    } catch(Exception ee){
      ee.printStackTrace();
    }
  }
  //only when client is remote
  public static void initializeStatic() throws Exception {
    providerLoaders = new Hashtable();
    PropertiesManager propsManager = new PropertiesManager();
    PropertiesWrapper providerPr = null;
    PropertiesWrapper temp = null;
    boolean error = false;
    CoreContext.setJvmName(Engine.JVMName);
    //providers properties
    providerPr = new PropertiesWrapper(Engine.PROVIDERS_PROPERTIES , new String[]{Engine.TEST_PROVIDER_PREFIX },null,Engine.SYSTEM_PROPS_FILENAME);
    propsManager.add(providerPr);
    temp = new PropertiesWrapper(Engine.COMMUNICATION_PROPERTIES , new String[]{Engine.COMMUNICATION_PREFIX},null,Engine.SYSTEM_PROPS_FILENAME);
    propsManager.add(temp);
    try {
      //loads settings
       propsManager.loadAll();
    } catch(Exception ee) {
      CommonLog.log("Error loding system properties! Will use default settings for communication");
      CommonLog.log(ee);
      error = true;
    }
    CommunicationContextImpl communication = null;
    try {
      Properties p = null;
      if(error) {
        p = new Properties();
        p.setProperty("communication.server" , "false");
        p.setProperty("communication.server.port" , "9090");
      } else {
        p = temp.getRuntimeProperties();
        p.setProperty("communication.server" , "false");
      }
      //make communication context
      communication = new CommunicationContextImpl(p);
      CoreContext.setCommunicationContext(communication);
    } catch(Exception ex) {
      CommonLog.log("Can not initialize Communication! Please check port settings!");
      CommonLog.log(ex);
      throw ex;
    }
    CoreContext.setPropertiesManager(propsManager);
    Properties property = CoreContext.getPropertiesManager().get(Engine.PROVIDERS_PROPERTIES).getRuntimeProperties();
    Enumeration enum = property.keys();
    while(enum.hasMoreElements()) {
      try {
        String prov = property.getProperty((String)enum.nextElement());
        int index = prov.indexOf(';');
        String providerImplName = prov.substring(0 , index).trim();
        String jar = prov.substring(index+1).trim();
        jar = new File("../lib/".replace('/' , File.separatorChar) + jar).getCanonicalPath();
        CoreClassLoader providerLoader  = new CoreClassLoader(MainFrameView.class.getClassLoader() , jar );
        providerLoaders.put(providerImplName , providerLoader);
        communication.setClassLoader(providerLoader);
      } catch(Exception ex){
        CommonLog.log("Can not initialize test provider!\n " +ex.getMessage() , Engine.FATAL_MESSAGE);
        CommonLog.log(ex);
      }
    }
  }

    public void stateChanged(ChangeEvent e) {
        Component c = tabbedPane.getSelectedComponent();
        if (c instanceof GUIPanelWrapper) {
          GUIPanelWrapper gcw = (GUIPanelWrapper)c;
          GUIRuntimeControlInterface comp = (GUIRuntimeControlInterface)this.guis.get(gcw.getWrapperName());
          JButton[] buttons = comp.getButtons();
          toolBar.removeAll();
          for (int i = 0 ; i < buttons.length ; i++) {
            toolBar.add(buttons[i]);
          }
          toolBar.addSeparator();
          toolBar.add(exitButton);

        }

    }
}