/*
 * Copyright (c) 2000 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_util/java/com/sap/tc/jtools/util/structures/Header.java#2 $
 */

package com.sap.tc.jtools.util.structures;

import java.util.Properties;

/**
 * generic XML header.
 *
 * A Header instance contains
 * <p> - a String tag
 * <p> - any number of String (parameter,value) pairs.
 *
 * <p>
 * Copyright:    Copyright (c) 2002
 * Company:      SAP AG
 * @author       BPL - Tools
 * @version 1.0
 */


public class Header implements java.io.Serializable {

    private String tag;
    private String[] parameterNames = new String[0];
    private String[] parameterValues = new String[0];

	/**
	 * Constructor
	 * 
	 * @param tag the header tag
	 */
    public Header(String tag) {
        this.tag = tag;
    }

    /**
     * Returns the header tag
     * @return tag
     */
    public String getTag() {
        return tag;
    }

    /**
     * Returns the value of the parameter with a given name (or null)
     * @param string parameter name
     * @return parameter value
     */
    public String getParameter(String string ) {
        if (string == null )
            return null;
        for ( int i = 0; i < parameterNames.length; i++) {
            if ( parameterNames[i].equals(string) ) {
                return parameterValues[i];
                }
        }
        return null;
    }

    /**
     * Sets the value of a given parameter. If the parameter is new,
     * it is added to the list
     * @param name parameter name
     * @param value parameter value
     */
    public void setParameter(String name, String value) {
        	if ( value == null )
        	     value = "<null>";
        for ( int i = 0; i < parameterNames.length; i++) {
            if ( parameterNames[i].equals(name) ) {
                parameterValues[i] = value;
                return;
            }
        }
        // add parameter + sort
        String[] tempNames = new String[parameterNames.length + 1];
        String[] tempValues = new String[parameterNames.length + 1];
        boolean inserted = false;

        for ( int i = 0; i < parameterNames.length; i++) {
                if ( ( name.compareTo(parameterNames[i]) < 0 ) && !inserted ) {
                    tempNames[i] =  name;
                    tempValues[i] =  value;
                    inserted = true;
                }
            if (inserted) {
                tempNames[i+1] =  parameterNames[i];
                tempValues[i+1] =  parameterValues[i];
            } else {
                tempNames[i] =  parameterNames[i];
                tempValues[i] =  parameterValues[i];
            }
        }
            if (!inserted) {
                tempNames[parameterNames.length] =  name;
                tempValues[parameterNames.length] =  value;
            }
        parameterNames = tempNames;
        parameterValues = tempValues;
    }

 
	
    /**
     * Compares two headers
     * @return true if tags, parameter names, and parameter values are respectively equal
     */
    public boolean eq(Header header2) {
        if (header2 == null)
            return false;
        if (!header2.tag.equals(tag))
            return false;
        if (parameterNames.length != header2.parameterNames.length)
        return false;
        for ( int i = 0; i < parameterNames.length; i++ ) {
            if ( ( !parameterNames[i].equals(header2.parameterNames[i]) )
                || ( !parameterValues[i].equals(header2.parameterValues[i]) ) )
                return false;
            }
        return true;
    }

    /**
     * Returns all parameter (alphabetically sorted by parameter name)
     * @return 2-d array with names (array[0][i]) and values (array[1][i])
     */
    public Properties getParameters() {
        Properties props = new Properties();
        for ( int i = 0; i < parameterNames.length; i++ ) {
            props.setProperty(parameterNames[i], parameterValues[i]);
        }
        return props;
    }

}