/*
 * Copyright (c) 2000 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_util/java/com/sap/tc/jtools/util/collections/IntStack.java#2 $
 */

package com.sap.tc.jtools.util.collections;

import java.util.EmptyStackException;

public class IntStack {

  private int[] intArray;
  private int currentPos = -1;
  private int initialCapacity;

  public IntStack() {
    this(10);
  }

  public IntStack(int initialCapacity) {
    if (initialCapacity < 1)
      throw new IllegalArgumentException("capacity must be at least 1");
    this.initialCapacity = initialCapacity;
    intArray = new int[initialCapacity];
  }

  public int peek() {
    if (currentPos == -1)
      throw new EmptyStackException();
    return intArray[currentPos];
  }

  public int pop() {
    if (currentPos == -1)
      throw new EmptyStackException();
    return intArray[currentPos--];
  }

  public void push(int value) {
    if (currentPos == intArray.length - 1) {
      doubleCapacity();
    }
    intArray[++currentPos] = value;
  }

  private void doubleCapacity() {
    int[] temp = new int[intArray.length * 2];
    System.arraycopy(intArray, 0, temp, 0, intArray.length);
    intArray = temp;
  }

  public boolean isEmpty() {
    return currentPos == -1;
  }

  public void clear() {
    intArray = new int[initialCapacity];
    currentPos = -1;
  }

}
