/*
 * Copyright (c) 2000 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_util/java/com/sap/tc/jtools/util/collections/FloatStack.java#2 $
 */

package com.sap.tc.jtools.util.collections;

import java.util.EmptyStackException;

public class FloatStack {

  private float[] floatArray;
  private int currentPos = -1;
  private int initialCapacity;

  public FloatStack() {
    this(10);
  }

  public FloatStack(int initialCapacity) {
    if (initialCapacity < 1)
      throw new IllegalArgumentException("capacity must be at least 1");
    this.initialCapacity = initialCapacity;
    floatArray = new float[initialCapacity];
  }

  public float peek() {
    if (currentPos == -1)
      throw new EmptyStackException();
    return floatArray[currentPos];
  }

  public float pop() {
    if (currentPos == -1)
      throw new EmptyStackException();
    return floatArray[currentPos--];
  }

  public void push(float value) {
    if (currentPos == floatArray.length - 1) {
      doubleCapacity();
    }
    floatArray[++currentPos] = value;
  }

  private void doubleCapacity() {
    float[] temp = new float[floatArray.length * 2];
    System.arraycopy(floatArray, 0, temp, 0, floatArray.length);
    floatArray = temp;
  }

  public boolean isEmpty() {
    return currentPos == -1;
  }

  public void clear() {
    floatArray = new float[initialCapacity];
    currentPos = -1;
  }
}
