/*
 * Copyright (c) 2000 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_util/java/com/sap/tc/jtools/util/collections/BooleanStack.java#2 $
 */

package com.sap.tc.jtools.util.collections;

import java.util.EmptyStackException;

public class BooleanStack {

  private boolean[] booleanArray;
  private int currentPos = -1;
  private int initialCapacity;

  public BooleanStack() {
    this(10);
  }

  public BooleanStack(int initialCapacity) {
    if (initialCapacity < 1)
      throw new IllegalArgumentException("capacity must be at least 1");
    this.initialCapacity = initialCapacity;
    booleanArray = new boolean[initialCapacity];
  }

  public boolean peek() {
    if (currentPos == -1)
      throw new EmptyStackException();
    return booleanArray[currentPos];
  }

  public boolean pop() {
    if (currentPos == -1)
      throw new EmptyStackException();
    return booleanArray[currentPos--];
  }

  public void push(boolean value) {
    if (currentPos == booleanArray.length - 1) {
      doubleCapacity();
    }
    booleanArray[++currentPos] = value;
  }

  private void doubleCapacity() {
    boolean[] temp = new boolean[booleanArray.length * 2];
    System.arraycopy(booleanArray, 0, temp, 0, booleanArray.length);
    booleanArray = temp;
  }

  public boolean isEmpty() {
    return currentPos == -1;
  }
  
  public void clear() {
    booleanArray = new boolean[initialCapacity];
    currentPos = -1;
  }

}
