/*
 * Copyright (c) 2000 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_util/java/com/sap/tc/jtools/util/ascii/StringList.java#2 $
 */

package com.sap.tc.jtools.util.ascii;

/**
 * list of strings.
 *
 *
 *
 * Copyright:    Copyright (c) 2001
 * Company:      SAP AG
 * @author       BPL - Tools
 * @version 1.0
 */


public class StringList {
    public String first;
    public StringList next;
    public StringList() {
        first = null;
        next = null;
    }

    public StringList(String string) {
        first = string;
        next = null;
    }

    public void addLast(String inLast) {
        if ( inLast == null )
            return;
        if ( first == null ) {
            first = inLast;
            return;
        }
        StringList current = this;
        while ( current.next != null ) {
            current = current.next;
        }
        current.next = new StringList(inLast);
        return;
    }

    public void addFirst(String inFirst) {
        if ( first == null ) {
            first = inFirst;
            return;
        }

        StringList temp = new StringList();
        temp.first = first;
        temp.next = next;
        first = inFirst;
        next = temp;
        return;
    }

    public String search(String string) {
        if ( first == null ) {
            return null;
        }
        if ( first.equals(string)) {
            return first;
        }
        if ( next != null) {
            return next.search(string);
        }
        return null;
    }

    public StringList append(StringList list) {
        StringList current = list;
        while ( current != null ) {
            addLast(current.first);
            current = current.next;
        }
        return this;
    }

}