/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_modelimpl/java/com/sap/tc/webdynpro/modelimpl/rfcadapter/WDExecuteRFCException.java#1 $
 */
package com.sap.tc.webdynpro.modelimpl.rfcadapter;

import com.sap.aii.proxy.framework.core.ApplicationFaultException;
import com.sap.aii.proxy.framework.core.BaseType;
import com.sap.aii.proxy.framework.core.SystemFaultException;
import com.sap.aii.util.misc.api.BaseRuntimeException;

/**
 * Thrown when the execution of an RFC fails.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_modelimpl/java/com/sap/tc/webdynpro/modelimpl/rfcadapter/WDExecuteRFCException.java#1 $
 */

public class WDExecuteRFCException extends WDRFCException
{

  /**
   * Creates a web dynpro RFC Execution exception
   */
  public WDExecuteRFCException(String messageText) {
    this(messageText, null, null);
  }

  /**
   * Creates a web dynpro RFC Execution exception
   */
  public WDExecuteRFCException(String messageText, Throwable reason) {
    this(messageText, null, reason);
  }

  /**
   * Creates a web dynpro RFC Execution exception
   */
  public WDExecuteRFCException(Throwable reason) {
    this(null, null, reason);
  }

  /**
   * Creates a web dynpro RFC Execution exception
   */
  public WDExecuteRFCException(String messageText, Object[] parameters) {
    this(messageText, parameters, null);
  }

  /**
   * Creates a web dynpro RFC Execution exception
   */
  public WDExecuteRFCException(String messageText, Object[] parameters, Throwable reason)
  {
    super(messageText, parameters, reason);
    if (  (reason!= null) &&
    	( (reason instanceof SystemFaultException) || (reason instanceof ApplicationFaultException)) )
      baseException = reason;
  }

  /**
   * Returns the expanded message text of the fault returned by the backend.
   */
  public String getMessage()
  {
    Throwable cause = getCause();
    if (baseException == null )
    {
			if (cause == null )
				{return getMessage();} 
			else
				{return cause.getMessage();}
    }

		String msg = null;
		if (baseException instanceof BaseRuntimeException)
			msg = ((BaseRuntimeException)baseException).getMessage();
		else if (baseException instanceof SystemFaultException)
		{
			BaseType baseType = ((SystemFaultException)baseException).getFault();
			if(baseType!=null)
				msg = baseType.toString();
		}
		else if (baseException instanceof ApplicationFaultException)
		{
			BaseType baseType = ((ApplicationFaultException)baseException).getFault();
			if(baseType!=null)
				msg = baseType.toString();
		}
		else
    	msg = baseException.getMessage();

    if (msg == null || "".equals(msg))
    {
      return cause.getMessage();
    }
    return msg;
  }

  /**
   * Returns the object carrying the fault information resulting from the backend exception raised.
   *
   * the returned object must be cast to the appropriate FaultType to access specific Fault properties.
   * See the specific RFC-Method in the <XXX>_PortType class of your RFC Adapter's proxy package
   * to determine which faults can be raised. <XXX> must be replayed by the specific name of the
   * RFC Adapter's Port_Type class.
   */
  public BaseType getFault()
  {
    if (baseException == null)
      return null;
    if (baseException instanceof ApplicationFaultException)
      return ((ApplicationFaultException)baseException).getFault();
    else if (baseException instanceof SystemFaultException)
      return ((SystemFaultException)baseException).getFault();
    return null;
  }

  private Throwable baseException = null;

}
