/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_devel/src/com/sap/tc/jtools/jlint/eclipse/devel/wizards/TestMessageDialog.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.devel.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.sap.tc.jtools.jtci.TestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;

public class TestMessageDialog extends Dialog {

  // child widgets
  private Button fOkButton;

  private Text fMsgKeyText;
  private Text fDisplayNameText;
  private Combo fPriorityCombo;

  private Label fMsgKeyLabel;
  private Label fDisplayNameLabel;
  private Label fPriorityLabel;

  private Label fMessageLabel;

  private ITestMessageDescription fResult;

  // mode: "edit" or "add"
  private boolean editMode;

  public TestMessageDialog(
    Shell pParentShell,
    ITestMessageDescription initialValues) {
    super(pParentShell);
    editMode = true;
    fResult = initialValues;
  }

  public TestMessageDialog(Shell pParentShell) {
    super(pParentShell);
    editMode = false;
  }

  /* (non-Javadoc)
   * Method declared on Dialog.
   */
  protected void buttonPressed(int buttonId) {
    if (buttonId == IDialogConstants.OK_ID) {
      String prioString =
        fPriorityCombo.getItems()[fPriorityCombo.getSelectionIndex()];
      int prio;
      if (ITestMessageDescription
        .ATTR_DYNAMIC_PRIO
        .equalsIgnoreCase(prioString)) {
        prio = ITestMessageDescription.PRIO_DYNAMIC;
      } else {
        prio = Integer.parseInt(prioString);
      }
      String key = fMsgKeyText.getText().trim();
      String displayName = fDisplayNameText.getText().trim();
      fResult = new TestMessageDescription(key, displayName, prio);
    } else {
      fResult = null;
    }
    super.buttonPressed(buttonId);
  }

  /* (non-Javadoc)
   * Method declared in Window.
   */
  protected void configureShell(Shell shell) {
    super.configureShell(shell);
    shell.setText("Enter Message Data");
  }

  /* (non-Javadoc)
   * Method declared on Dialog.
   */
  protected void createButtonsForButtonBar(Composite parent) {
    // create OK and Cancel buttons by default
    fOkButton =
      createButton(
        parent,
        IDialogConstants.OK_ID,
        IDialogConstants.OK_LABEL,
        true);
    fOkButton.setEnabled(false);

    // cancel button needs not to be observed    
    createButton(
      parent,
      IDialogConstants.CANCEL_ID,
      IDialogConstants.CANCEL_LABEL,
      false);

    //do this here because setting the text will set enablement on the ok button
    fMsgKeyText.setFocus();
    validateInput();
  }

  /* (non-Javadoc)
   * Method declared on Dialog.
   */
  protected Control createDialogArea(Composite parent) {
    // create composite
    Composite composite = (Composite) super.createDialogArea(parent);
    composite.setLayout(new GridLayout(2, false));

    fMsgKeyLabel = new Label(composite, SWT.NONE);
    fMsgKeyLabel.setLayoutData(
      new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
    fMsgKeyLabel.setText("Msg Key");

    fMsgKeyText = new Text(composite, SWT.SINGLE | SWT.BORDER);
    fMsgKeyText.setLayoutData(
      new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
    fMsgKeyText.addModifyListener(new ModifyListener() {
      public void modifyText(ModifyEvent e) {
        validateInput();
      }
    });

    fDisplayNameLabel = new Label(composite, SWT.NONE);
    fDisplayNameLabel.setLayoutData(
      new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
    fDisplayNameLabel.setText("Display Name");

    fDisplayNameText = new Text(composite, SWT.SINGLE | SWT.BORDER);
    fDisplayNameText.setLayoutData(
      new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
    fDisplayNameText.addModifyListener(new ModifyListener() {
      public void modifyText(ModifyEvent e) {
        validateInput();
      }
    });

    fPriorityLabel = new Label(composite, SWT.NONE);
    fPriorityLabel.setLayoutData(
      new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
    fPriorityLabel.setText("Priority");

    fPriorityCombo = new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
    fPriorityCombo.setItems(
      new String[] {
        "1",
        "2",
        "3",
        ITestMessageDescription.ATTR_DYNAMIC_PRIO });
    fPriorityCombo.setLayoutData(
      new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
    fPriorityCombo.select(0);
    if (fResult != null) {
      // set initial values
      fMsgKeyText.setText(fResult.getKey());
      fDisplayNameText.setText(fResult.getDisplayName());
      int prio = fResult.getPriority();
      String prioString = String.valueOf(prio);
      if (ITestMessageDescription.PRIO_DYNAMIC == prio) {
        fPriorityCombo.select(3);
      } else {
        String[] items = fPriorityCombo.getItems();
        for (int i = 0; i < items.length; i++) {
          if (items[i].equals(prioString)) {
            fPriorityCombo.select(i);
          }
        }
      }
    }

    fMessageLabel = new Label(composite, SWT.NONE);
    fMessageLabel.setText("Message Key and Display Name must not be empty");
    GridData gd =
      new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL);
    gd.horizontalSpan = 2;
    fMessageLabel.setLayoutData(gd);

    validateInput();
    return composite;
  }

  protected ITestMessageDescription getResult() {
    return fResult;
  }

  /**
   * Validates the input.
   */
  protected void validateInput() {
    String msgKey = fMsgKeyText.getText().trim();
    String displayName = fDisplayNameText.getText().trim();
    boolean okay = msgKey.length() > 0 && displayName.length() > 0;
    // may be called before initializing GUI!
    if (fOkButton != null && fMessageLabel != null) {
      fOkButton.setEnabled(okay);
      fMessageLabel.setVisible(!okay);
    }
  }

}
