/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_devel/src/com/sap/tc/jtools/jlint/eclipse/devel/wizards/ParametersPage.java#1 $
 */
package com.sap.tc.jtools.jlint.eclipse.devel.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.devel.extension.ExtensionManager;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;

/**
 * @author D037913
 */
public class ParametersPage extends WizardPage {

  private Table fInputParamTable;
  private Table fTestMessageTable;

  public ParametersPage(String pageName) {
    super(pageName);
  }

  public void createControl(Composite parent) {
    Composite composite = new Composite(parent, SWT.NONE);
    int nColumns = 4;
    GridLayout layout = new GridLayout();
    layout.numColumns = nColumns;
    layout.makeColumnsEqualWidth = false;
    composite.setLayout(layout);
    setDescription("Enter Runtime Test Parameters and Test Messages");
    createTestParametersControls(composite, nColumns);
    createTestMessagesControls(composite, nColumns);
    setControl(composite);
  }

  private void createTestParametersControls(Composite composite, int nColumns) {
    Label paramsLabel = new Label(composite, SWT.NONE);
    paramsLabel.setText(TextKeyDevelWizards.PARAMS_LABEL
        .getText());
    paramsLabel.setLayoutData(gridDataForLabel(1));
    // input parameter table
    fInputParamTable = new Table(composite, SWT.SINGLE | SWT.BORDER
        | SWT.FULL_SELECTION);
    TableLayout tl = new TableLayout();
    tl.addColumnData(new ColumnWeightData(50, true));
    tl.addColumnData(new ColumnWeightData(50, true));
    fInputParamTable.setLayout(tl);
    GridData gd = new GridData(GridData.FILL_BOTH);
    gd.grabExcessHorizontalSpace = true;
    gd.grabExcessVerticalSpace = true;
    gd.horizontalSpan = 2;
    fInputParamTable.setLayoutData(gd);
    fInputParamTable.setHeaderVisible(true);
    fInputParamTable.setLinesVisible(true);
    new TableColumn(fInputParamTable, SWT.NONE)
        .setText(TextKeyDevelWizards.PARAM_NAME_LABEL.getText());
    new TableColumn(fInputParamTable, SWT.NONE)
        .setText(TextKeyDevelWizards.PARAM_TYPE_LABEL.getText());
    // add/remove/edit buttons
    {
      Composite compButton = new Composite(composite, SWT.NONE);
      compButton.setLayout(new GridLayout()	);
      Button addButton = new Button(compButton, SWT.PUSH);
      addButton.setText(TextKeyDevelWizards.ADD_LABEL.getText());
      addButton.setLayoutData(gridDataForButton(addButton,1));
      addButton.addSelectionListener(new SelectionAdapter() {

        public void widgetSelected(SelectionEvent evt) {
          InputParameterDialog dlg = new InputParameterDialog(JlinPlugin
              .getActiveWorkbenchShell(), getTestParameters());
          if (Window.OK == dlg.open() && null != dlg.getResult()) {
            ParameterInterface result = dlg.getResult();
            TableItem newItem = new TableItem(fInputParamTable, SWT.NONE);
            newItem.setText(new String[]{result.getName(), result.getType()});
            newItem.setData(result);
          }
        }
      });
      Button editButton = new Button(compButton, SWT.PUSH);
      editButton.setText(TextKeyDevelWizards.EDIT_LABEL.getText());
      editButton.setLayoutData(gridDataForButton(editButton,1));
      editButton.addSelectionListener(new SelectionAdapter() {

        public void widgetSelected(SelectionEvent evt) {
          int selIdx = fInputParamTable.getSelectionIndex();
          if (selIdx < 0) {
            // nothing selected
            return;
          }
          TableItem selItem = fInputParamTable.getItem(selIdx);
          ParameterInterface selParam = (ParameterInterface) selItem.getData();
          InputParameterDialog dlg = new InputParameterDialog(JlinPlugin
              .getActiveWorkbenchShell(), selParam, getTestParameters());
          if (Window.OK == dlg.open() && null != dlg.getResult()) {
            ParameterInterface result = dlg.getResult();
            selItem.setText(new String[]{result.getName(), result.getType()});
            selItem.setData(result);
          }
        }
      });
      Button deleteButton = new Button(compButton, SWT.PUSH);
      deleteButton.setText(TextKeyDevelWizards.REMOVE_LABEL.getText());
      deleteButton.setLayoutData(gridDataForButton(deleteButton,1));
      deleteButton.addSelectionListener(new SelectionAdapter() {

        public void widgetSelected(SelectionEvent evt) {
          int delNdx = fInputParamTable.getSelectionIndex();
          if (0 <= delNdx) {
            fInputParamTable.remove(delNdx);
            if (delNdx < fInputParamTable.getItemCount()) {
              fInputParamTable.setSelection(delNdx);
            } else if (0 != fInputParamTable.getItemCount()) {
              fInputParamTable.setSelection(0);
            }
          }
        }
      });
    }
  }

  private void createTestMessagesControls(Composite composite, int nColumns) {
    Label msgsLabel = new Label(composite, SWT.NONE);
    msgsLabel.setText("Messages");
    msgsLabel.setLayoutData(gridDataForLabel(1));
    // test msg table
    fTestMessageTable = new Table(composite, SWT.SINGLE | SWT.BORDER
        | SWT.FULL_SELECTION);
    TableLayout tl = new TableLayout();
    tl.addColumnData(new ColumnWeightData(30, true));
    tl.addColumnData(new ColumnWeightData(50, true));
    tl.addColumnData(new ColumnWeightData(20, true));
    fTestMessageTable.setLayout(tl);
    GridData gd = new GridData(GridData.FILL_BOTH);
    gd.grabExcessHorizontalSpace = true;
    gd.grabExcessVerticalSpace = true;
    gd.horizontalSpan = 2;
    fTestMessageTable.setLayoutData(gd);
    fTestMessageTable.setHeaderVisible(true);
    fTestMessageTable.setLinesVisible(true);
    new TableColumn(fTestMessageTable, SWT.NONE).setText("Msg Key");
    new TableColumn(fTestMessageTable, SWT.NONE).setText("Display Name");
    new TableColumn(fTestMessageTable, SWT.NONE).setText("Priority");
    // add/remove/edit buttons
    {
      Composite compButton = new Composite(composite, SWT.NONE);
      compButton.setLayout(new GridLayout());
//      compButton.setLayoutData(new GridData(GridData.FILL_BOTH));
      Button addButton = new Button(compButton, SWT.PUSH);
      addButton.setText(TextKeyDevelWizards.ADD_LABEL.getText());
      addButton.setLayoutData(gridDataForButton(addButton,1) );
      addButton.addSelectionListener(new SelectionAdapter() {

        public void widgetSelected(SelectionEvent evt) {
          TestMessageDialog dlg = new TestMessageDialog(JlinPlugin
              .getActiveWorkbenchShell());
          if (Window.OK == dlg.open() && null != dlg.getResult()) {
            ITestMessageDescription result = dlg.getResult();
            TableItem newItem = new TableItem(fTestMessageTable, SWT.NONE);
            String prio = result.getPriority() == ITestMessageDescription.PRIO_DYNAMIC
                ? ITestMessageDescription.ATTR_DYNAMIC_PRIO
                : String.valueOf(result.getPriority());
            newItem.setText(new String[]{result.getKey(),
                result.getDisplayName(), prio});
            newItem.setData(result);
          }
        }
      });
      Button editButton = new Button(compButton, SWT.PUSH);
      editButton.setText(TextKeyDevelWizards.EDIT_LABEL.getText());
      editButton.setLayoutData(gridDataForButton(editButton,1) );
      editButton.addSelectionListener(new SelectionAdapter() {

        public void widgetSelected(SelectionEvent evt) {
          int selIdx = fTestMessageTable.getSelectionIndex();
          if (selIdx < 0) {
            // nothing selected
            return;
          }
          TableItem selItem = fTestMessageTable.getItem(selIdx);
          ITestMessageDescription selMsg = (ITestMessageDescription) selItem
              .getData();
          TestMessageDialog dlg = new TestMessageDialog(JlinPlugin
              .getActiveWorkbenchShell(), selMsg);
          if (Window.OK == dlg.open() && null != dlg.getResult()) {
            ITestMessageDescription result = dlg.getResult();
            String prio = result.getPriority() == ITestMessageDescription.PRIO_DYNAMIC
                ? ITestMessageDescription.ATTR_DYNAMIC_PRIO
                : String.valueOf(result.getPriority());
            selItem.setText(new String[]{result.getKey(),
                result.getDisplayName(), prio});
            selItem.setData(result);
          }
        }
      });
      Button deleteButton = new Button(compButton, SWT.PUSH);
      deleteButton.setText(TextKeyDevelWizards.REMOVE_LABEL.getText());
      deleteButton.setLayoutData(gridDataForButton(deleteButton,1) );
      deleteButton.addSelectionListener(new SelectionAdapter() {

        public void widgetSelected(SelectionEvent evt) {
          int delNdx = fTestMessageTable.getSelectionIndex();
          if (0 <= delNdx) {
            fTestMessageTable.remove(delNdx);
            if (delNdx < fTestMessageTable.getItemCount()) {
              fTestMessageTable.setSelection(delNdx);
            } else if (0 != fTestMessageTable.getItemCount()) {
              fTestMessageTable.setSelection(0);
            }
          }
        }
      });
    }
  }

  private void setButtonGridData(Button button) {
    GridData gridData = new GridData();
    button.setLayoutData(gridData);
    SWTUtil.setButtonDimensionHint(button);
  }

  /**
   * Returns the test parameters.
   * 
   * @return ParameterInterface[]
   */
  public ParameterInterface[] getTestParameters() {
    if (fInputParamTable == null)
      return new ParameterInterface[0];
    TableItem[] items = fInputParamTable.getItems();
    Vector params = new Vector();
    for (int i = 0; i < items.length; i++) {
      params.add((ParameterInterface) items[i].getData());
    }
    return (ParameterInterface[]) params.toArray(new ParameterInterface[params
        .size()]);
  }

  public ITestMessageDescription[] getMessages() {
    if (fTestMessageTable == null)
      return new ITestMessageDescription[0];
    TableItem[] items = fTestMessageTable.getItems();
    List params = new ArrayList();
    for (int i = 0; i < items.length; i++) {
      params.add((ITestMessageDescription) items[i].getData());
    }
    return (ITestMessageDescription[]) params
        .toArray(new ITestMessageDescription[params.size()]);
  }

  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.jface.wizard.IWizardPage#getNextPage()
   */
  public IWizardPage getNextPage() {
    String generatorName = ((NewTestWizard) getWizard()).getMainPage()
        .getTestType();
    IWizardPage[] addPages = ExtensionManager.getExtensionManager()
        .getAdditionalPages(generatorName);
    if (addPages == null || addPages.length == 0)
      return null;
    return addPages[0];
  }
  
	protected static GridData gridDataForLabel(int span) {
		GridData gd= new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		gd.horizontalSpan= span;
		return gd;
	}

	protected static GridData gridDataForButton(Button button, int span) {
		GridData gd= new GridData();
		gd.horizontalAlignment= GridData.FILL;
		gd.grabExcessHorizontalSpace= false;
		gd.horizontalSpan= span;
		gd.heightHint = SWTUtil.getButtonHeigthHint(button);
		gd.widthHint = SWTUtil.getButtonWidthHint(button);		
		return gd;
	}		

}
