/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_devel/src/com/sap/tc/jtools/jlint/eclipse/devel/wizards/NewTestWizard.java#3 $
 */
package com.sap.tc.jtools.jlint.eclipse.devel.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.wizard.IWizardPage;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.eclipse.devel.extension.ExtensionManager;
import com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator;
import com.sap.tc.jtools.jlint.eclipse.devel.generation.TestDescriptorTool;

public class NewTestWizard extends NewElementWizard {

  private MainPage       fMainPage;
  private ParametersPage fParamPage;

  public NewTestWizard() {
    super();
    setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
    setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
    setWindowTitle("New JLin Test Class"); //$NON-NLS-1$
  }

  /*
   * @see Wizard#createPages
   */
  public void addPages() {
    fMainPage = new MainPage();
    fMainPage.init(getSelection());
    addPage(fMainPage);
    fParamPage = new ParametersPage("Enter Test Parameters and Messages");
    addPage(fParamPage);
    ExtensionManager man = ExtensionManager.getExtensionManager();
    String[] generators = man.getTestGeneratorNames();
    for (int i = 0; i < generators.length; i++) {
      IWizardPage[] pages = man.getAdditionalPages(generators[i]);
      if (pages == null || pages.length == 0)
        continue;
      for (int j = 0; j < pages.length; j++) {
        addPage(pages[j]);
      }
    }
  }

  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.jdt.internal.ui.wizards.NewElementWizard#finishPage(org.eclipse.core.runtime.IProgressMonitor)
   */
  protected void finishPage(IProgressMonitor monitor)
      throws InterruptedException, CoreException {
    if (monitor == null) {
      monitor = new NullProgressMonitor();
    }
    fMainPage.createType(monitor);
    ITestGenerator testGenerator = getTestGenerator();
    TestDescriptionSet testDescriptionSet = TestDescriptorTool
        .getTestDescriptionSet(fMainPage.getTestDescriptor());
    TestDescriptionSet newTestDescrSet = TestDescriptorTool
        .addTestDefinitionToDescrSet(testGenerator.getTestDefinition(),
            testDescriptionSet, fMainPage.getTestGroup());
    TestDescriptorTool.saveTestDescriptionSet(newTestDescrSet, fMainPage
        .getTestDescriptor());
    // refresh tests.xml so it will show up in GUI
    IFile descrIFile = fMainPage.getTestDescrIFile();
    descrIFile.refreshLocal(IResource.DEPTH_ZERO, null);
    // open java editor for created class
    IJavaElement origEl = fMainPage.getCreatedType().getCompilationUnit()
        .getOriginalElement();
    selectAndReveal(origEl.getCorrespondingResource());
    JavaUI.openInEditor(origEl);
  }

  private ITestGenerator getTestGenerator() {
    ITestGenerator gen = ExtensionManager.getExtensionManager()
        .getTestGenerator(fMainPage.getTestType());
    gen.init(fMainPage.getPackageText().trim(), fMainPage.getTypeName().trim(),
        fMainPage.getTestName(), fMainPage.getTestGroup(), fMainPage
            .getTestDescription(), fMainPage.getTestResponsible(), fParamPage
            .getTestParameters(), fParamPage.getMessages());
    return gen;
  }

  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.jface.wizard.IWizard#canFinish()
   */
  public boolean canFinish() {
    IWizardPage currentPage = this.getContainer().getCurrentPage();
    return currentPage.isPageComplete() && currentPage.getNextPage() == null;
  }
  
  public MainPage getMainPage() {
    return fMainPage;
  }

  public ParametersPage getParametersPage() {
    return fParamPage;
  }

}