/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_devel/src/com/sap/tc/jtools/jlint/eclipse/devel/generation/TestDescriptorTool.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.devel.generation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

import com.sap.tc.jtools.jlint.TestDefinition;
import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jlint.extension.TestSet;
import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.TestTreeNode;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * TODO: description of this class/interface 
 * @author D037913
 */
public class TestDescriptorTool {

  private TestDescriptorTool() {
  }

  public static TestDescriptionSet getTestDescriptionSet(File descrFile) {
    if (!descrFile.isFile()) {
      // no tests.xml present, so we generate an empty one
      TestTree tree = new TestTree();
      tree.setName(null);
      return new TestDescriptionSet("JLIN", 1, tree);//$NON-NLS-1$
    }
    FileReader reader = null;
    try {
      reader = new FileReader(descrFile);
    } catch (FileNotFoundException e) {
      ExceptionHandler.handle(e);
      return null;
    }
    try {
      return new TestDescriptionSet(XMLTool.parseReader(reader));
    } catch (Exception e) {
      ExceptionHandler.handle(e);
      return null;
    } finally {
      try {
        reader.close();
      } catch (IOException e) {
        ExceptionHandler.handle(e);
      }
    }

  }

  public static TestDescriptionSet addTestDefinitionToDescrSet(
    TestDefinition testDef,
    TestDescriptionSet testSet,
    String testGroup) {
    TestTreeNode newNode = null;
    if (!testGroup.equals("")) {
      TestTree groupTree = new TestTree();
      groupTree.setName(testGroup);
      groupTree.addTree(testDef);
      newNode = groupTree;
    } else {
      newNode = testDef;
    }
    TestTree tree =testSet.getTestTree(); 
    tree.addTree(newNode);
    return new TestDescriptionSet(testSet.getName(),testSet.getVersion(),tree);
  }

  public static void saveTestDescriptionSet(
    TestDescriptionSet set,
    File descrFile) {
    FileWriter writer = null;
    try {
      File dir = descrFile.getParentFile(); 
      if (!dir.isDirectory()) {
        // create parent dir
        dir.mkdirs();
      }
      writer = new FileWriter(descrFile);
      XMLTool.writeDocument(set.toStructureTree(), writer);
    } catch (IOException e) {
      ExceptionHandler.handle(e);
    } finally {
      if (writer != null) {
        try {
          writer.close();
        } catch (IOException e) {
          ExceptionHandler.handle(e);
        }
      }
    }
  }

}
