/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_devel/src/com/sap/tc/jtools/jlint/eclipse/devel/extension/ITestGenerator.java#3 $
 */

package com.sap.tc.jtools.jlint.eclipse.devel.extension;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.wizard.IWizardPage;

import com.sap.tc.jtools.jlint.TestDefinition;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;

public interface ITestGenerator {

  public void init(
    String packageName,
    String className,
    String displayName,
    String testGroup,
    String description,
    String responsible,
    ParameterInterface[] inputParameters,
    ITestMessageDescription[] messages);

  public IWizardPage[] getAdditionalPages();

  public String getSuperClass();
  
  public void createTypeMembers(IType testClass, NewTypeWizardPage.ImportsManager importsMan);
  
  public void wizardFinished();
  
  public String getTestObjectType();
  
  public String[] getRequiredPluginIds();
  
  public ParameterInterface[] getInternalParameters();
  
  public TestDefinition getTestDefinition();

}
