/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_devel/src/com/sap/tc/jtools/jlint/eclipse/devel/extension/ExtensionManager.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.devel.extension;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;

import com.sap.tc.jtools.jlint.eclipse.devel.DevelPlugin;

public class ExtensionManager {

  private static final String TESTGENERATOR_EXT_POINT = "testGenerator";
  private static final String TESTGENERATOR_ELEMENT = "testGenerator";
  private static final String CLASS_ATTRIBUTE = "class";
  private static final String DISPLAYNAME_ATTRIBUTE = "displayName";

  private static ExtensionManager manager;

  private Map testGenerators = new HashMap();
  private Map name2WizardPagesMap = new HashMap();

  public static ExtensionManager getExtensionManager() {
    if (manager != null)
      return manager;
    else
      return manager = new ExtensionManager();
  }

  private ExtensionManager() {
    try {
      init();
    } catch (CoreException e) {
      DevelPlugin.log(e);
      throw new IllegalArgumentException();
    }
  }

  /**
   * initialize testGenerator extension point implementations 
   */
  private void init() throws CoreException {
    IPluginRegistry registry = Platform.getPluginRegistry();
    initTestGenerators(
      registry.getExtensionPoint(
        DevelPlugin.getPluginId(),
        TESTGENERATOR_EXT_POINT));

  }

  private void initTestGenerators(IExtensionPoint testGenExtensionPoint)
    throws CoreException {
    IExtension[] testGeneratorExtensions =
      testGenExtensionPoint.getExtensions();
    for (int i = 0; i < testGeneratorExtensions.length; i++) {
      IConfigurationElement[] elements =
        testGeneratorExtensions[i].getConfigurationElements();
      for (int j = 0; j < elements.length; j++) {
        if (TESTGENERATOR_ELEMENT.equals(elements[j].getName())) {
          ITestGenerator testGenerator =
            (ITestGenerator) elements[j].createExecutableExtension(
              CLASS_ATTRIBUTE);
          String displayName = elements[j].getAttribute(DISPLAYNAME_ATTRIBUTE);
          testGenerators.put(displayName, testGenerator);
          name2WizardPagesMap.put(displayName, testGenerator.getAdditionalPages());
        }
      }
    }
  }

  public String[] getTestGeneratorNames() {
    return (String[]) testGenerators.keySet().toArray(new String[0]);
  }

  public ITestGenerator getTestGenerator(String generatorName) {
    return (ITestGenerator) testGenerators.get(generatorName);
  }
  
  public IWizardPage[] getAdditionalPages(String generatorName) {
    return (IWizardPage[]) name2WizardPagesMap.get(generatorName);
  }

}
