/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_devel/src/com/sap/tc/jtools/jlint/eclipse/devel/extension/AbstractTestGenerator.java#3 $
 */

package com.sap.tc.jtools.jlint.eclipse.devel.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.wizard.IWizardPage;

import com.sap.tc.jtools.jlint.TestDefinition;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;

/**
 * TODO: description of this class/interface 
 * @author D037913
 */
public abstract class AbstractTestGenerator implements ITestGenerator {

  private String className;
  private String packageName;
  private String responsible;
  private String description;
  private String displayName;
  private String testGroup;
  private ParameterInterface[] inputParameters;
  private ITestMessageDescription[] messages;

  /**
   * subclasses may override to create additional class members 
   */
  public void createTypeMembers(
    IType testclass,
    NewTypeWizardPage.ImportsManager importsMan) {
  }

  /**
   * subclasses must implement to specify testobject type
   */
  public abstract String getTestObjectType();

  /**
   * subclasses may override to specify additional Wizard pages 
   */
  public IWizardPage[] getAdditionalPages() {
    return new IWizardPage[0];
  }

  /**
   * subclasses may override to specify additional internal parameters
   */
  public ParameterInterface[] getInternalParameters() {
    return new ParameterInterface[0];
  }

  protected final String getClassName() {
    return className;
  }

  protected final String getDescription() {
    return description;
  }

  protected final String getDisplayName() {
    return displayName;
  }

  protected String getResourceBundle() {
    return null;
  }

  protected final String getTestGroup() {
    return testGroup;
  }

  private ParameterInterface[] getMergedInputParameters() {
    List params = new ArrayList();
    params.addAll(Arrays.asList(inputParameters));
    params.addAll(Arrays.asList(getAdditionalInputParameters()));
    return (ParameterInterface[]) params.toArray(new ParameterInterface[0]);
  }

  protected ParameterInterface[] getAdditionalInputParameters() {
    return new ParameterInterface[0];
  }

  protected final String getPackageName() {
    return packageName;
  }

  protected final String getResponsible() {
    return responsible;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#getTestDefinition()
   */
  public TestDefinition getTestDefinition() {
    String testPackage = getPackageName().trim();
    String testClass =
      testPackage.equals("")
        ? getClassName().trim()
        : testPackage + "." + getClassName().trim();
    ParameterInterface classNameParameter =
      ParameterTool.createParameter(
        TestDefinition.PARAMETER_TEST_CLASS,
        ParameterTool.PAR_TYPE_STRING,
        testClass);
    List internalParams = Arrays.asList(getInternalParameters());
    List newParams = new ArrayList();
    newParams.addAll(internalParams);
    newParams.add(classNameParameter);
    try {
      return new TestDefinition(
        getDisplayName(),
        getDescription(),
        getResponsible(),
        getResourceBundle(),
        "1.0",
        (ParameterInterface[]) newParams.toArray(new ParameterInterface[0]),
        getTestObjectType(),
        getMergedInputParameters(),
        messages);
    } catch (BadTreeException e) {
      ExceptionHandler.handle(e);
      return null;
    }
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#init(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, com.sap.tc.jtools.jtci.interfaces.ParameterInterface[])
   */
  public final void init(
    String packageName,
    String className,
    String displayName,
    String testGroup,
    String description,
    String responsible,
    ParameterInterface[] inputParameters,
    ITestMessageDescription[] messages) {
    this.packageName = packageName;
    this.className = className;
    this.displayName = displayName;
    this.testGroup = testGroup;
    this.description = description;
    this.responsible = responsible;
    this.inputParameters = inputParameters;
    this.messages = messages;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#wizardFinished()
   */
  public void wizardFinished() {
  }

}
