/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_devel/src/com/sap/tc/jtools/jlint/eclipse/devel/DevelPlugin.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.devel;

import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DevelPlugin extends AbstractUIPlugin {

  private static DevelPlugin develPlugin;

  public DevelPlugin(IPluginDescriptor descriptor) {
    super(descriptor);
    develPlugin = this;
  }

  public static DevelPlugin getDevelPlugin() {
    return develPlugin;
  }

  public static void log(Throwable t) {
    log(new Status(IStatus.ERROR, getPluginId(), IStatus.ERROR, "Error", //$NON-NLS-1$
    t));
  }

  public static void log(IStatus pStatus) {
    develPlugin.getLog().log(pStatus);
  }

  public static String getPluginId() {
    return develPlugin.getDescriptor().getUniqueIdentifier();
  }

}
