package com.sap.caf.km.ejb.svc.propmetadata;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public interface IPropMetadata {

	/**
	 * Gets available namespaces
	 * @return	An array of available namespaces 
	 * @throws PropException
	 */
	public IPropNamespace[] getNamespaces() throws PropException;
	
  /**
   * Gets ordered meta name list.
   *
   * @return An array of meta names
   * @exception KMPropException   Exception raised in failure situation
   * @throws KMPropException
   */
  public IPropMetaName[] getNames() throws PropException;
	
	/**
	 * Gets array of meta names with given namespace 
	 * @param namespace		A namespace to filter meta names
	 * @return	An array of metanames 
	 * @throws PropException
	 */
  public IPropMetaName[] getNames(IPropNamespace namespace) throws PropException;
  
  /**
   * Returns properties with a specific meta group
   *
   * @param groupId - A Meta Group Id as filter criterium
   * @return An array of Meta Names
   * @exception KMPropException   Exception raised in failure situation
   * @throws KMPropException
   */
  public IPropMetaName[] getNames(String groupId) throws PropException;

	/**
	 * Gets an array of meta names by given namespace and group
	 * @param namespace A namespace to filter meta names
	 * @param groupId	A group id to filter meta names
   * @return An array of meta names
	 * @throws PropException
	 */  
  public IPropMetaName[] getNames(IPropNamespace namespace, String groupId) throws PropException;

  /**
   * Gets ordered group array. This groups are usually registert in config framework (s. implementation)
   *
   * @return An array of KMPropMetaGroup
   * @exception KMPropException Exception raised in failure situation
   * @throws KMPropException
   */
  public IPropMetaGroup[] getGroups() throws PropException;

	/**
		* Gets ordered group array by given namespace
		* @param namespace A namespace to filter meta names
	 	* @return An array of KMPropMetaGroup
		* @exception KMPropException Exception raised in failure situation
		* @throws KMPropException
		*/
	public IPropMetaGroup[] getGroups(IPropNamespace namespace) throws PropException;

}
