package com.sap.caf.km.ejb.svc.propmetadata;

/**
 * Name part of name - value pairs. Meta name value pairs can be configured to use
 * them i.e. in UI to select property name and values.
 *
 */
public interface IPropMetaName {

  public final static int SORTMODE_ASCENDING = 0;
  public final static int SORTMODE_DESCENDING = 1;

  public final static String PROPERTY_TYPE_BOOLEAN = "Boolean";
  public final static String PROPERTY_TYPE_DATE = "Date";
  public final static String PROPERTY_TYPE_INTEGER = "Integer";
  public final static String PROPERTY_TYPE_RID = "RID";
  public final static String PROPERTY_TYPE_STRING = "String";
  public final static String PROPERTY_TYPE_TEXT = "Text";
  public final static String PROPERTY_TYPE_TIMESTAMP = "Timestamp";
  public final static String PROPERTY_TYPE_TIME = "Time";
  public final static String PROPERTY_TYPE_USER = "User";
  public final static String PROPERTY_TYPE_URL = "URL";
  public final static String PROPERTY_TYPE_XML = "XML";
  public final static String PROPERTY_TYPE_HTML = "HTML";

  public final static String NS_SEPARATOR = ":";
  public final static String DEFAULT_NAMESPACE_ALIAS = "default";

  /**
   * shortest complete ID (name, alias:name or namespace:name, depending on alias
   * availability or alias being "default"
   *
   * @return The Id value
   */
  String getId();

  /**
   * Complete ID ({namespace}name)
   *
   * @return The Id value
   */
  String getFullId();
	
  /**
   * property name without namespace or alias
   *
   * @return The Name value
   */
  String getName();

  /**
   * namespace
   *
   * @return Property namespace
   */
  String getNamespace();

  /**
   * Each meta property name belongs to a group like system, custom, default, etc.
   * NOTE: Can be null if no group info is available!
   *
   * @return Meta group info
   */
  String getGroupId();

  /**
   * Get description (internationalized)
   *
   * @param locale  Description of the param
   * @return The description value or null, if not available
   */
  String getDescription();

  /**
   * Returns an ordered value list.
   *
   * @return an ordered alowed value list.
   */
  IPropMetaValue[] getAllowedValues();

  /**
   * Ask for if the list of values is not empty.
   *
   * @return Returns true, if list of values is not empty.
   */
  boolean hasAllowedValues();

  /**
   * Returns the PropertyType attribute of the MetaName object.
   *
   * @return propertyType
   */
  String getType();

  /**
   * Delivers a flag which marks this property as being mandatory
   *
   * @return mandatory flag
   */
  boolean isMandatory();

  /**
   * Delivers a flag which is used by TREX and Indexmanagement.
   *
   * @return indexable Flag
   */
  boolean isIndexable();

  /**
   * @return true if property should be hidden, false else
   */
  boolean isHidden();
	
  /**
   * @return true if property can be maintained, false else
   */
  boolean isMaintainable();

  /**
   * @return   true if property is a virtual property (maintainable only when the
   *      resource has this property), false else
   */
  boolean isVirtual();
	
  /**
   * @return   true if property is read-only, false else
   */
  boolean isReadonly();

  /**
   * @return   the allowed resource types
   */
  String[] getResourceTypes();

  /**
   * @return   the allowed mime types
   */
  String[] getMimeTypes();
	
  /**
   * @return the validity patterns for folders
   */
  String[] getFolderPatterns();

  /**
   * @return   the validity patterns for documents
   */
  String[] getDocumentPatterns();

  /**
   * @return   an array of additional meta tags
   */
  String[] getAdditionalMetaTags();
  
  /**
   * Delivers the default value
   *
   * @return   value or null, if unset
   */
  IPropMetaValue getDefaultValue();

  /**
   * get multi-value attribute
   *
   * @return   boolean flag
   */
  boolean isMultiValued();

  /**
   * Delivers a flag which marks this property as being explicitly modelled (not
   * on-the-fly)
   *
   * @return   modelled flag
   */
  boolean isModelled();
  
  /**
   * returns the default sort mode (ascending/descending)
   *
   * @return   KMPropMetaName.SORTMODE_ASCENDING/KMPropMetaName.SORTMODE_DESCENDING
   */
  int getDefaultSortmode();

  /**
   * @return   all meta names which composed this meta name
   */
  IPropMetaName[] getComposedOfMetaNames();

  /**
   * Flag that indicates that the property value affects the value or state of other properties
   * or other objects in the current context.
   * @return true if the property has dependencies
   */
  boolean hasDependencies();
}

