package com.sap.caf.km.ejb.svc.idxsearch.common;

import java.io.Serializable;

/**
 * This class represents a search result object
 * 
 * @author joerg.schleiwies@sap.com 
 * @author aliaksandr_pranko@epam.com 
 */
public interface ISearchResult extends Serializable {

	/**
	 * The method gets KM resource RID
	 * 
	 * @return	The KM resource RID
	 */
	public String getRid();
	public void setRid(String sRid);
	
	/**
	 * The method gets MOF_ID.
	 * If result object is a CAF object, it is stored under /CAF/MOF_ID/... (changed from /xApps/MOF_ID/...)
	 * When you browse, you will see not the MOF_ID, but the displayName, so you have to take it 
	 * from the RID. If result object is a KM resource, the value will not be filled.
	 * 
	 * @return	The search result object's MOF_ID
	 */
	public String getMofId();	
	public void setMofId(String sMofId);	
	
	/**
	 * The method gets display name of the result object
	 * 
	 * @return	The search result object's display name 
	 */
	public String getBOName();
	public void setBOName(String sBOName);	
	
	/**
	 * The method gets BOGuid. That is last part of RID.
	 * 
	 * @return		The BO Guid
	 */	
	public String getBOGuid();	
	public void setBOGuid(String sBOGuid);	
		
	/**
	 * The method gets result object's type (Task, Document or CAF object).
	 * The possible values is <code>ISearchResult.TYPE_TASK, 
	 * ISearchResult.TYPE_DOCUMENT, ISearchResult.TYPE_CAF_BO, ISearchResult.TYPE_UNDEFINED <code>. 
	 * 
	 * @return	The object's type (Task, Document or CAF object).
	 */	
	public int getType();
	public void setType(int type);	
	
	/**
	 * The method gets object's source (KM or CAF).
	 * The possible values is <code>ISearchResult.SOURCE_KM, ISearchResult.SOURCE_CAF<code>.<br> 
	 * This value will be obtained from the first piece of the RID , if it is not /CAF, 
	 * it must be KM.
	 * 
	 * @return	The object's source (KM or CAF)
	 */
	public int getSource();	
	public void setSource(int source);	
		
	/**
	 * @see #getType()
	 */
	public static final int TYPE_TASK = 0;
	
	/**
	 * @see #getType()
	 */	
	public static final int TYPE_DOCUMENT = 1;

	/**
	 * @see #getType()
	 */	
	public static final int TYPE_UNDEFINED = 2;

	/**
	 * @see #getType()
	 */	
	public static final int TYPE_CAF_BO = 3;
	
	
	/**
	 * @see #getSource()
	 */
	public static final int SOURCE_KM = 0;
	
	/**
	 * @see #getSource()
	 */	
	public static final int SOURCE_CAF = 1;
}




