/*
 * Created on Jun 19, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndex;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexException;

/**
 * The interface exposes KM index administration functionality to CAF site 
 * @author viachaslau_kudzinau@epam.com
 */
public interface IIndexSearchIndex {

	/** Index Creation */

	/**
	 * Creates index and attach corresponding BO-folder
	 * @param BOName	BO type name
	 * @throws IndexException  
	 */
	public IIndex createIndexForCAFBO(String BOName) throws IndexException;

	/**
	 * Detach BO-folder and delete index in the sense of related resources
	 * @param BOName	BO type name
	 */
	public void deleteIndexForCAFBO(String BOName) throws IndexException;

	/**
	 * Creates related index and attach corresponding BO-folder
	 * @param BOName	BO type name
	 * @throws IndexException  
	 */
	public IIndex createRelatedIndexForCAFBO(String BOName) throws IndexException;

	/**
	 * Detach BO-folder and delete related index in the sense of related resources
	 * @param BOName	BO type name
	 */
	public void deleteRelatedIndexForCAFBO(String BOName) throws IndexException;

	/** Index lookup **/

	/**
	 * Returns list of all existing indexes
	 * @return IIndex[]	array of all existing indexes
	 */
	public IIndex[] getAllIndexes() throws IndexException;

	/**
	 * Gets a specified index
	 * @param indexId	identificator of the index to be returned
	 * @return IIndex 
	 */
	public IIndex getIndex(String indexId) throws IndexException;

	/** global KM index handling **/

	/**
	 * Writes the index-ID into a database table as value to the name of the corresponding KM-BO via JDBC
	 * @param indexId	Identificator of the index to be linked to the BO
	 * @param BOName 	BO type name
	 */
	public void assignGlobalIndexToKMBO(String indexId, String BOName) throws IndexException;

	/**
	 * Removes the entry from the database table
	 * @param indexId Id of index to be unassign
	 * @param BOName	BO type name 
	 */
	public void unassignGlobalIndexFromKMBO(String indexId, String BOName) throws IndexException;

	/** updating indexes */

	/**
	 * Add a created object to an index. Replicated to lifecycle method of EJB
	 * @param BOName	BO type name
	 */
	public void indexObject(String BOName, String objectRid) throws IndexException;

	/**
	 * Add a related object to an index.
	 * @param BOName	BO type name
	 */
	public void indexRelatedObject(String BOName, String objectRid) throws IndexException;
	
	/**
	 * Removes a BO from an index, if the BO is deleted
	 * @param BOName		BO type name
	 * @param objectRid		RID of the object being deleted
	 */
	public void deindexObject(String BOName, String objectRid) throws IndexException;

	/**
	 * Removes a BO from an related index, if the BO is deleted
	 * @param BOName		BO type name
	 * @param objectRid		RID of the object being deleted
	 */
	public void deindexRelatedObject(String BOName, String objectRid) throws IndexException;
	
	/**
	 * Performs a reindex of proper BO type
	 * @param BOName BO type name
	 */
	public void reindexProperIndex(String BOName) throws IndexException;

	/**
	 * Clears specified index
	 * @param BOName BO type name
	 */
	public void clearIndex(String indexId) throws IndexException;

	/**
	 * Performs a reindex of a whole KM-related index for BO type
	 * @param BOName BO type name
	 */
	public void reindexRelatedIndex(String BOName) throws IndexException;
	/**
	 * Performs a reindex of a global index for BO-respository
	 * @param BOName BO type name
	 */
	public void reindexGlobalIndex(String IndexId, String BOName) throws IndexException;

	/**
	 * Performs a reindex only on changed or deleted items
	 * @param BOName	BO type name
	 * @throws KMIndexExcpetion
	 */
	public void deltaReindex(String BOName) throws IndexException;

	/** 
	 * Mark local index cache as invalid.
	 * Cache refreshs in next retrieve indexs operation 
	 * @throws IndexException
	 */
	public void invalidateIndexCache();

	/**
	 * Performs delete specified index from KM side 
	 * @param indexId Id of index to be deleted
	 * @param BOName	BO type name
	 * @throws IndexException
	 */
	public void deleteGlobalIndex(String indexId, String BOName) throws IndexException;

}
