package com.sap.caf.km.ejb.svc.cleanjob;

public interface ICleanJobSchedule {

	/**
	 * Sets CleanJob task run hours 
	 * @param hours (0 - 23)
	 */
	public void setHours(int hours);

	/**
	 * Gets CleanJob task run hours
	 * @return hours (0 - 23)
	 */
	public int getHours();

	/**
	 * Sets CleanJob task run minutes 
	 * @param minutes (0 - 59)
	 */
	public void setMinutes(int minutes);

	/**
	 * Gets CleanJob task run minutes
	 * @return minutes (0 - 69)
	 */
	public int getMinutes();

	/**
	 * Sets CleanJob task run days of week 
	 * @param weekDays set of days of week (using Calndar values)
	 * @see java.util.Calendar
	 */
	public void setWeekDays(int[] weekDays);

	/**
	 * Gets CleanJob task run days of week
	 * @return set of days of week (using Calndar values) 
	 * @see java.util.Calendar
	 */
	public int[] getWeekDays();

}
