package com.sap.caf.km.ejb.svc.cleanjob;

import javax.ejb.EJBLocalObject;

public interface CleanJobProxyEJBLocal extends EJBLocalObject {

	/**
	 * @return schedule for CleanJob task
	 * @throws CleanJobException
	 */
	public ICleanJobSchedule getCleanJobSchedule() throws CleanJobException;

	/**
	 * Updates schedule for CleanJob task
	 * @param schedule
	 * @throws CleanJobException
	 */
	public void setCleanJobSchedule(ICleanJobSchedule schedule) throws CleanJobException;

	/**
	 * Check and return status of CleanJob task
	 * @return true if task is running at current time
	 * @throws CleanJobException
	 */
	public boolean isCleanJobRunning() throws CleanJobException;

	/**
	 * Enables or disables CleanJob task
	 * @param bEnabled set true to enable CleanJob task or false to disable  
	 * @throws CleanJobException
	 */
	public void setCleanJobEnabled(boolean bEnabled) throws CleanJobException;

	/**
	 * @return true if CleanJob task is enabled 
	 * @throws CleanJobException
	 */
	public boolean getCleanJobEnabled() throws CleanJobException;


	/**
	 * Enables or disables documents cleaning by CleanJob task.
	 * @param bEnabled set true to enable CleanJob task or false to disable  
	 * @throws WSProxyException
	 */
	public void setCleanDocuments(boolean bEnabled) throws CleanJobException;

	/**
	 * @return true if documents cleaning by CleanJob is enabled 
	 * @throws WSProxyException
	 */
	public boolean getCleanDocuments() throws CleanJobException;


	/**
	 * Enables or disables cleaning of unlinked discussion rooms by CleanJob task.
	 * @param bEnabled set true to enable CleanJob task or false to disable  
	 * @throws WSProxyException
	 */
	public void setCleanUnlinkedDiscussionRooms(boolean bEnabled) throws CleanJobException;

	/**
	 * @return true if cleaning of unlinked discussion rooms by CleanJob is enabled 
	 * @throws WSProxyException
	 */
	public boolean getCleanUnlinkedDiscussionRooms() throws CleanJobException;


	/**
	 * Runs CleanJob task immediately, regardless of shedule and CleanJob is enabled or disabled  
	 * @throws CleanJobException
	 */
	public void cleanTempFolders() throws CleanJobException;

}
