package com.sap.caf.km.ejb.data.folder;
import java.util.Collection;

import javax.ejb.EJBLocalObject;

import com.sap.caf.km.ejb.data.util.KMNodeException;
import com.sap.caf.km.ejb.data.util.NodeChildren;
import com.sap.caf.km.ejb.data.util.NodeContent;
import com.sap.caf.km.ejb.data.util.NodeHeader;
public interface FolderProxyEJBLocal extends EJBLocalObject {

	/**
	 * Business Method.  
	 */
	public void createFolderHeader(String name, String parentRid, String displayName, String description, Collection relations)
		throws KMNodeException;

	/**
	 * Business Method.
	 */
	public NodeHeader readFolderHeader(String name, String parentRid) throws KMNodeException;

	/**
	 * Business Method.
	 */
	public NodeContent readFolderContent(String name, String parentRid) throws KMNodeException;

	/**
	 * Business Method.
	 */
	public void deleteFolder(String name, String parentRid) throws KMNodeException;

	/**
	 * Delete empty folders starting from the root: <code>parentRid</code>/<code>name</code>
	 * Root is also deleted if it's empty
	 * 
	 * @param name A name of root folder
	 * @param parentRid A parentRid for root folder 
	 * @throws KMNodeException
	 */
	public void deleteEmptyFolders(String name, String parentRid) throws KMNodeException;
	
	/**
	 * Business Method.
	 */
	public void saveFolderHeader(String name, String parentRid, String displayName, String description, Collection relations)
		throws KMNodeException;

	/**
	 * Business Method.
	 */
	public void saveFolderContent(
		String name,
		String parentRid,
		long contentLength,
		String contentType,
		String contentEncoding,
		byte[] content)
		throws KMNodeException;

	/**
	 * Business Method.
	 */
	public Collection findFolder(String searchString, String startSearchRid) throws KMNodeException;

	/** 
	 * Business Method.
	 */
	public NodeHeader[] getChildren(String name, String parentRid) throws KMNodeException;
	
	public NodeChildren getNodeChildren(String name, String parentRid) throws KMNodeException;

	/**
	 * Business Method.
	 */
	public boolean exists(String folderRid) throws KMNodeException;

	/**
		 * Business Method.
		 */
	public void move(String sourceRid, String targetRid) throws KMNodeException;

}
