package com.sap.caf.km.ejb.data.document;
import java.util.Collection;

import javax.ejb.EJBLocalObject;

import com.sap.caf.km.ejb.data.util.KMNodeException;
import com.sap.caf.km.ejb.data.util.NodeContent;
import com.sap.caf.km.ejb.data.util.NodeHeader;
public interface DocumentProxyEJBLocal extends EJBLocalObject {


	/**
	 * Business Method.
	 */
	public void createDocumentHeader(String name, String parentRid, String displayName, String description, String link, Collection relations ) throws KMNodeException;


	/**
	 * Business Method.
	 */
	public NodeHeader readDocumentHeader(String name, String parentRid) throws KMNodeException;
	public NodeHeader[] readDocumentHeaders(String[] rids) throws KMNodeException;


	/**
	 * Business Method.
	 */
	public NodeContent readDocumentContent(String name, String parentRid) throws KMNodeException;

	/**
	 * Business Method.
	 */
	public void deleteDocument(String name, String parentRid) throws KMNodeException;


	/**
	 * Business Method.
	 */
	public void saveDocumentHeader(String name, String parentRid, String displayName, String description, String link, Collection relations ) throws KMNodeException;


	/**
	 * Business Method.
	 */
	public void saveDocumentContent(String name, String parentRid, long contentLength, String contentType, String contentEncoding, byte[] content) throws KMNodeException;


	/**
	 * Business Method.
	 */
	public Collection findDocument(String searchString, String startSearchRid) throws KMNodeException;


	/**
	 * Converts a KM RID to KM URL to be used to <b>preview</b> a document having RID as pathname.
	 * @param rid 	A document KM RID 
	 * @return	KM URL to preview document content 
	 * @throws KMNodeException
	 */
	public String getDocumentURLforPreview(String rid) throws KMNodeException;

	/**
	 * Converts a KM RIDs collection to KM URLs collection to be used to <b>preview</b> a documents having 
	 * corresponding RIDs as pathnames.
	 * @param rids A KM RIDs correspond to documents
	 * @return	KM URLs collection to preview documents content
	 * @throws KMNodeException
	 */
	public Collection getDocumentURLforPreview(Collection rids) throws KMNodeException;

	/**
	 * Converts a KM RID to KM URL to be used to <b>edit</b> a document having RID as pathname.
	 * @param rid 	A document KM RID 
	 * @return	KM URL to edit document content 
	 * @throws KMNodeException
	 */
	public String getDocumentURLforEdit(String rid) throws KMNodeException;

	/**
	 * Converts a KM RIDs collection to KM URLs collection to be used to <b>edit</b> a documents having 
	 * corresponding RIDs as pathnames.
	 * @param rids A KM RIDs correspond to documents
	 * @return	KM URLs collection to edit documents content
	 * @throws KMNodeException
	 */
	public Collection getDocumentURLforEdit(Collection rids) throws KMNodeException;


	/**
	 * Call KM Relation Service to get a collection of RIDs related with 
	 * specified <code>docRid</code>
	 * 
	 * @param docRid A Document RID
	 * @return	A Collection of related BO RIDs
	 * @throws KMNodeException
	 */
	public Collection getDocumentRelations(String docRid) throws KMNodeException;
	
	/**
	 * Call KM Relation Service to update relations between <code>docRid</code>
	 * and related BOs RIDs specified as <code>boRids</code> 
	 * 
	 * @param docRid	A Document RID
	 * @param boRids	A collection of BO RIDs having as an attachment <code>docRid</code>
	 * @throws KMNodeException
	 */
	public void updateDocumentRelations(String docRid, Collection boRids) throws KMNodeException;


	/**
	 * Business Method.
	 */
	public boolean exists(String documentRid) throws KMNodeException;

	/**
	 * Business Method.
	 */
	public void move(String sourceRid, String targetRid) throws KMNodeException;

	public String copyToFolder(String srcResRid, String dstDirRid) throws KMNodeException;

	/**
	 * Business Method.
	 */
	public void copy(String sourceRid, String targetRid) throws KMNodeException;

	/**
	 * Business Method.
	 */
	public void link(String sourceRid, String targetRid) throws KMNodeException;
	
	// Methods deals with document versions
	public boolean isDocumentLocked(String documentRid) throws KMNodeException;
	public boolean unlockDocument(String documentRid) throws KMNodeException;
	public String getLockOwner (String documentRid) throws KMNodeException;	
	public void disableDocumentVersioning (String rid) throws KMNodeException;
	public void enableDocumentVersioning (String rid) throws KMNodeException;
	public boolean isDocumentVersioned (String rid) throws KMNodeException;
	public String[] getVersionHistory(String rid)throws KMNodeException;
	public void setAsCurrentVersion (String historyRid, String rid) throws KMNodeException;
	public void deleteVersion (String historyRid) throws KMNodeException;
	public String getCurrentVersion(String documentRid) throws KMNodeException;
	public boolean authorizationCheck(String documentRid) throws KMNodeException;

	public String relateKMDocument(String boID, String boGUID, String kmRID) throws KMNodeException;
	public String copyBODocument(String fullBOName, String boGuid, String kmRid) throws KMNodeException;
	public Collection copyAttachedKMDocuments(String fullBOName, String boGuid, Collection srcRids) throws KMNodeException;

} 

