/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id $
 */
 package com.sap.tc.webdynpro.pdfobject.api;

import com.sap.tc.webdynpro.pdfobject.core.PDFObject;

/**
 * WDPDFObjectFactory handels the instance management/caching of PDFObjects.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDPDFObjectFactory {
  private static final WDPDFObjectFactory INSTANCE = new WDPDFObjectFactory();
  
  /**
   * Constructor 
   */ 
  private WDPDFObjectFactory() {
    super();
  }

  /**
   * Method getInstance returns the factory singleton
   * @return
   */
  private static WDPDFObjectFactory getInstance(){
    return INSTANCE;    
  }
  
  /**
   * Method getPDFObject returns a PDFObject that can be used for communication
   * with ADS.
   * 
   * @return IWDPDFObject
   */
  public static IWDPDFObject getPDFObject(){
    // TODO implement cache
    return new PDFObject();
  }
}
