/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_pdfobject/java/com/sap/tc/webdynpro/pdfobject/api/WDInteractiveFormPermissionModes.java#1 $
 */
package com.sap.tc.webdynpro.pdfobject.api;

/**
 * Permission modes depicts what can be changed by the user without breaking the 
 * certificate. WDInteractiveFormPermissionModes enumerates the possible permis
 * sion modes necessary while certifying a PDF document by the ADS. These possible 
 * permission modes are as follows : 
 *  1. "None"
 *  2. "FormFields"
 *  3. "FormFieldsAndComments"
 * Application needs to set the permission mode before calling applyCertificate
 * in PDFObject API. The default permission mode is "FormFields". 
 *   
 * @author SAP
 */
public final class WDInteractiveFormPermissionModes {
  
  /** Permission modes related to Certification. */
  
  /** Certification permission mode defaulted to "FormFields" */
  private String permissionMode;

  /** Permission modes to make a document password protected.  */
  
  /** "all" allows full permission – if present, overrides all other permission 
   * values 
   */
  public static final WDInteractiveFormPermissionModes ALL;

  /** "accessibility" allows text to be extracted by screen readers, etc – does 
   * not apply if compatibility is Acrobat_3 
   */
  public static final WDInteractiveFormPermissionModes ACCESSIBILITY;  
  
  /** "contentExtraction" - text and other copying is permitted */
  public static final WDInteractiveFormPermissionModes CONTENT_EXTRACTION;
  
  /** "changesNotAllowed" - no changes are allowed to the document – this option 
   * is mutually exclusive with the other "changes*" permissions. 
   */
  public static final WDInteractiveFormPermissionModes CHANGES_NOT_ALLOWED;
  
  /** "changesDocumentAssembly" - only allow a user to assemble additional content 
   * – this option is mutually exclusive with the other "changes*" permissions. 
   */
  public static final WDInteractiveFormPermissionModes CHANGES_DOCUMENT_ASSEMBLY;
  
  /** "changesFillAndSign" - only allow someone to fill in form fields, then apply 
   * a signature – this option is mutually exclusive with the other "changes*" 
   * permissions 
   */
  public static final WDInteractiveFormPermissionModes CHANGES_FILL_AND_SIGN;
  
  /** "changesEditNotesFillAndSign" - allow someone to add and edit notes, fill 
   * in form fields, and apply a signature – this option is mutually exclusive 
   * with the other "changes*" permissions – this option does not apply if 
   * compatibility is Acrobat_3 
   */
  public static final WDInteractiveFormPermissionModes CHANGES_EDIT_NOTES_FILL_AND_SIGN;
  
  /** "changesAllowed" - all changes are allowed (except for extracting pages) – 
   * this option is mutually exclusive with the other "changes*" permissions 
   */
  public static final WDInteractiveFormPermissionModes CHANGES_ALLOWED;
  
  /** "printNotAllowed" - disable the capability to print the document – mutually 
   * exclusive with printLowQuality and printHighQuality 
   */
  public static final WDInteractiveFormPermissionModes PRINT_NOT_ALLOWED;
  
  /** "printLowQuality" - only allow the document to be printed at low quality – 
   * mutually exclusive with printHighQuality and printNotAllowed – not applicable 
   * if compatibility is set to Acrobat_3. 
   */
  public static final WDInteractiveFormPermissionModes PRINT_LOW_QUALITY;
  
  /** "printHighQuality" - document can be printed at highest quality – mutually 
   * exclusive with printLowQuality and printNotAllowed – of the three print options, 
   * printHighQuality will be used if nothing is specified. 
   */
  public static final WDInteractiveFormPermissionModes PRINT_HIGH_QUALITY;
  
  /** 
   * WDInteractiveFormPermissionModes object depicting "None" for certification.
   */
  public static final WDInteractiveFormPermissionModes NONE;
  
  /** 
   * WDInteractiveFormPermissionModes object depicting "FormFields" for certification.
   */
  public static final WDInteractiveFormPermissionModes FORM_FIELDS;
  
  /** WDInteractiveFormPermissionModes object depicting "FormFieldsAndComments" */
  public final static WDInteractiveFormPermissionModes FORM_FIELDS_AND_COMMENTS;
  
  /** static block initializing all the permission modes. */
  static{
    
    // Certification related.
    NONE = new WDInteractiveFormPermissionModes("None");
    FORM_FIELDS = new WDInteractiveFormPermissionModes("FormFields");
    FORM_FIELDS_AND_COMMENTS = 
            new WDInteractiveFormPermissionModes("FormFieldsAndComments");
    
    // Password Protection related.
    ALL = new WDInteractiveFormPermissionModes("all");
    ACCESSIBILITY = new WDInteractiveFormPermissionModes("accessibility");
    CONTENT_EXTRACTION = 
            new WDInteractiveFormPermissionModes("contentExtraction");
    CHANGES_NOT_ALLOWED = 
            new WDInteractiveFormPermissionModes("changesNotAllowed");
    CHANGES_DOCUMENT_ASSEMBLY = 
            new WDInteractiveFormPermissionModes("changesDocumentAssembly");
    CHANGES_FILL_AND_SIGN = 
            new WDInteractiveFormPermissionModes("changesFillAndSign");
    CHANGES_EDIT_NOTES_FILL_AND_SIGN = 
            new WDInteractiveFormPermissionModes("changesEditNotesFillAndSign");
    CHANGES_ALLOWED = new WDInteractiveFormPermissionModes("changesAllowed");
    PRINT_NOT_ALLOWED = new WDInteractiveFormPermissionModes("printNotAllowed");
    PRINT_LOW_QUALITY = new WDInteractiveFormPermissionModes("printLowQuality");
    PRINT_HIGH_QUALITY = new WDInteractiveFormPermissionModes("printHighQuality"); 
    
  }

  /** Default permission for certification. */
  public final static WDInteractiveFormPermissionModes CERT_DEFAULT_PERMISSION = 
                                   WDInteractiveFormPermissionModes.FORM_FIELDS;

  /**
   * Constructor for creating individual permission modes. Private so that the 
   * class can not be instantiated by the application. Permission modes must be
   * the one among the possible values specified. 
   *  
   * @param permissionMode
   */
  private WDInteractiveFormPermissionModes(String permissionMode){
    this.permissionMode = permissionMode;
  }
  
  /**
   * Returns the String representation of the permission mode under consideration.
   * 
   * @return String
   */
  public String toString(){
    return this.permissionMode;     
  }
  
}
