/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_pdfobject/java/com/sap/tc/webdynpro/pdfobject/api/WDFormRights.java#2 $
 */
package com.sap.tc.webdynpro.pdfobject.api;

import com.sap.tc.webdynpro.pdfobject.core.PDFObjectConstants;

/**
 * Class WDFormRights.
 * @author SAP
 * @SAPWebDynproPart 2
 */
public final class WDFormRights extends WDUsageRight {
  
  public static final WDFormRights FILL_IN;
  public static final WDFormRights IMPORT;
  public static final WDFormRights EXPORT;
  public static final WDFormRights ADD;
  public static final WDFormRights DELETE;
  public static final WDFormRights SUBMIT_STANDALONE;
  public static final WDFormRights SPAWN_TEMPLATE;
  static{
    FILL_IN = new WDFormRights(PDFObjectConstants.FILL_IN);
    IMPORT = new WDFormRights(PDFObjectConstants.IMPORT);
    EXPORT = new WDFormRights(PDFObjectConstants.EXPORT);
    ADD = new WDFormRights(PDFObjectConstants.ADD);
    DELETE = new WDFormRights(PDFObjectConstants.DELETE);
    SUBMIT_STANDALONE = new WDFormRights(PDFObjectConstants.SUBMIT_STANDALONE);
    SPAWN_TEMPLATE = new WDFormRights(PDFObjectConstants.SPAWN_TEMPLATE);
  }
  
  /**
   * Constructor
   */
  protected WDFormRights(String value) {
    super(value);
  }

}
