/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_pdfobject/java/com/sap/tc/webdynpro/pdfobject/api/WDAnnotRights.java#2 $
 */
package com.sap.tc.webdynpro.pdfobject.api;

import com.sap.tc.webdynpro.pdfobject.core.PDFObjectConstants;

/**
 * Class WDAnnotRights
 * @author SAP
 * @SAPWebDynproPart 2
 */
public final class WDAnnotRights extends WDUsageRight {

  public static final WDAnnotRights CREATE;
  public static final WDAnnotRights DELETE;
  public static final WDAnnotRights MODIFY;
  public static final WDAnnotRights COPY;
  public static final WDAnnotRights IMPORT;
  public static final WDAnnotRights EXPORT;
  static{
    CREATE = new WDAnnotRights(PDFObjectConstants.CREATE);
    DELETE = new WDAnnotRights(PDFObjectConstants.DELETE);
    MODIFY = new WDAnnotRights(PDFObjectConstants.MODIFY);
    COPY = new WDAnnotRights(PDFObjectConstants.COPY);
    IMPORT = new WDAnnotRights(PDFObjectConstants.IMPORT);
    EXPORT = new WDAnnotRights(PDFObjectConstants.EXPORT);
  }
  /**
   * Constructor
   */
  protected WDAnnotRights(String value) {
    super(value);
  }
}
