/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/interfaces/TestDescriptionInterface.java#3 $
 */

package com.sap.tc.jtools.jtci.interfaces;

import com.sap.tc.jtools.jtci.TestTreeNode;

/**
 * Interface representing a test definition. All of the test properties
 * can be found out using the interface methods.
 * 
 * <p>In order for a test to be available, its description must
 * be included in the active tool descriptor 
 * 
 * <p>(The supported parameters  are listed in 
 * com.sap.tc.jtools.jtci.interfaces.ParameterInterface).
 * 
 */

public interface TestDescriptionInterface extends TestTreeNode {

  public String PARAMETER_TAG_TEST = "TEST"; //$NON-NLS-1$

  /**
   * Returns the test name
   *
   */
  public String getName();

  /**
   * Returns a text describing the test
   *
   */
  public String getDescription();

  /**
   * Returns an identification key (name, etc.) of the test author
   *
   */
  public String getTestResponsible();

  /**
   * Returns the resource bundle for the test (or null)
   *
   */
  public String getResourceBundle();

  /**
   * Returns the test version
   *
   */
  public String getVersion();

  /**
   * Returns the test internal parameter with a given name
   *
   */
  public ParameterInterface getInternalParameter(String parameterName);
  /**
   * Returns the test internal parameters.
   *
   */
  public ParameterInterface[] getInternalParameters();

  /**
   * Returns the input parameter with a given name
   *
   */
  public ParameterInterface getInputParameter(String parameterName);

  /**
   * Returns the list of test parameters (with their default values, if defined)
   *
   */
  public ParameterInterface[] getInputParameters();

  /**
   * Returns the messages that the test may produce
   */
  public ITestMessageDescription[] getMessages();
  /**
   * Returns the required test object type
   *
   */
  public String getObjectType();

}