/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/interfaces/ResultInterface.java#3 $
 */

package com.sap.tc.jtools.jtci.interfaces;

import java.util.Properties;

import com.sap.tc.jtools.jtci.TestObjectPosition;
import com.sap.tc.jtools.util.persistable.Persistable;


/**
 * Interface for a generic test result.
 * <p> Result properties:
 * <p> - test name
 * <p> - test parameters
 * <p> - target name
 * <p> - error priority
 * <p> - error message (deep structure)
 * <p> - error parameters (deep structure)
 *
 * <p>
 * Copyright:    Copyright (c) 2001
 * Company:      SAP AG
 * @author       BPL - Tools
 * @version 1.0
 */


public interface ResultInterface extends Persistable {

    /**
     * Severity level used for JLin-internal errors
     *
     */
    public static final int SEVERITY_INTERNAL_ERROR = 0;

    /**
     * Severity level used for errors
     *
     */
    public static final int SEVERITY_ERROR = 1;

    /**
     * Severity level used for warnings
     *
     */
    public static final int SEVERITY_WARNING = 2;

    /**
     * Severity level used for information messages
     *
     */
    public static final int SEVERITY_INFO = 3;    

    /**
     * Severity level used for internal messages
     *
     */
    public static final int SEVERITY_IGNORE = 10;    

    /**
     * Returns the test name
     *
     */
    public String getTestName();


    /**
     * Returns the test object type
     *
     */
    public String getTestObjectType();
    
    /**
     * Returns the ID of the test object (i.e. the source that was tested)
     *
     */
    public String getTestObjectID();

    /**
     * Returns the result position (within the test object) - it can be null
     *
     */
    public TestObjectPosition getResultPosition();
      

    /**
     * Returns the error priority
     *
     */
    public int getPriority();

    /**
     * Returns the error message text
     *
     */
    public String getErrorText();
    
    /**
     * Sets the error message text
     *
     */
    public void setErrorText(String text);
    
    /**parameterstext
     *
     */
    public Properties getErrorParameters();    

	public void setParameters(Properties errorMessageParameters);

}

