/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/interfaces/ParameterInterface.java#2 $
 */

package com.sap.tc.jtools.jtci.interfaces;

import com.sap.tc.jtools.util.persistable.*;

/**
 * Interface representing a test parameter.
 * <p> A parameter must belong to one of the following types:
 * <ul>
 * <li> - STRING: its value is an object of type java.lang.String.  
 * </li>
 * <li> - STRING[]: its value is an array of objects of type java.lang.String.  
 * </li>
 * <li> - DEEP STRUCTURE: its value is an object of type com.sap.tc.jtools.jtci.structures.StructureTree. 
 * </li>
 * </ul>
 * Copyright (c) 2001, SAP AG
 */

public interface ParameterInterface extends java.io.Serializable, Persistable {

	/**
	 * Returns the parameter name
	 *
	 */
	public String getName();

	/**
	 * Returns the parameter type
	 *
	 */
	public String getType();

	/**
	 * Returns the parameter value (as an object of the appropriate class)
	 *
	 */
	public java.io.Serializable getValue();

	/**
	 * Sete the parameter value
	 *
	 */
	public void setValue(java.io.Serializable value);

	/**
	 * Return a string representation of the parameter value
	 *
	 */
	public String valueToString();

	/**
	* Return a string representation of the whole parameter
	*
	*/
	public String toString();


	public String INPUT_PARAMETER_TAG = "INPUT_PARAMETER"; //$NON-NLS-1$

	public String PARAMETER_NAME = "NAME"; //$NON-NLS-1$  
	public String PARAMETER_TYPE = "TYPE"; //$NON-NLS-1$  
	public String PARAMETER_VALUE = "VALUE"; //$NON-NLS-1$

}