/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/interfaces/Listener.java#2 $
 */

package com.sap.tc.jtools.jtci.interfaces;

/**
 * listeners can be used to monitor and stop test execution.
 * 
 * Copyright (c) 2003, SAP AG
 */
public interface Listener {

    public static int CANCEL = -1;
    public static int CONTINUE = 0;

    /**
     * this method should be executed by the monitored process every time a test object has been processed.  
     */    
    public void processedTestObject(ResultInterface[] results);

    /**
     * this method should be executed by the monitored process 
     * every time a test object component has been processed.
     * 
     * The exact meaning of test object component depends on the the test object type. 
     *   
     */   
    public void processedTestObjectComponent();
    
    /**
     * this method can be used by the monitored process to check if the execution
     * should be stopped.
     * 
     * @return <code>true</code> if execution should be stopped.
     *   
     */      
    public boolean isCanceled();

}
