/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/interfaces/JtciDataInterface.java#2 $
 */

package com.sap.tc.jtools.jtci.interfaces;

/**
 * represents a generic data item that can be provided to JLin 
 * (e.g. to avoid performing unnecessary computation steps) 
 *
 * Copyright (c) 2003, SAP AG
 */
public interface JtciDataInterface {

	/**
	 * returns the data name (typically the name of the implementing class)
	 * 
	 * @return name
	 */
	public String getName();

	/**
	 * returns the data parameters.
	 * 
	 * The combination of name and parameters uniquely identifies the data
	 * 
	 * @return parameters
	 */
	public ParameterInterface[] getParameters();

	/**
	 * returns the content ot this data item.
	 * 
	 * @return data
	 */
	public Object getData();
}
