/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/interfaces/ITestMessageDescription.java#2 $
 */

package com.sap.tc.jtools.jtci.interfaces;

import com.sap.tc.jtools.util.persistable.Persistable;

/**
 * This interface represents a message that can be used by a test.
 * A message consists of a message key for localization, a priority
 * (may be DYANMIC) and a display name used in reports etc.
 * Example snippet of tests descriptor file:
 * 
 * <TEST>
 *  [...]
 *  <MESSAGES>
 *    <MESSAGE KEY="mykey" PRIO="1" DISPLAYNAME="My Message"/>
 *    <MESSAGE KEY="mykey2" PRIO="2" DISPLAYNAME="My 2nd Message"/>
 *  </MESSAGES>
 * </TEST>  
 * 
 * @author D037913
 */
public interface ITestMessageDescription extends Persistable {

  String TAG_MESSAGES = "MESSAGES";
  String TAG_MESSAGE = "MESSAGE";
  String TAG_KEY = "KEY";
  String TAG_DISPLAY_NAME = "DISPLAYNAME";
  String TAG_PRIO = "PRIO";
  String ATTR_DYNAMIC_PRIO = "DYNAMIC";
  int PRIO_DYNAMIC = -1;

  public String getKey();

  public int getPriority();

  public String getDisplayName();

}
