/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/exceptions/NestableException.java#2 $
 */

package com.sap.tc.jtools.jtci.exceptions;

import java.io.*;

/**
 * An Exception that has a constructor with another exception
 * as argument. Can be used to wrap exceptions without losing
 * the stacktrace of the nested exception.
 *
 */

public class NestableException extends Exception {

  /** Exception that might have caused this one. */
  private Throwable cause;

  public NestableException() {
    super();
  }

  /**
   * Constructs an exception with the given descriptive message.
   * @param msg Description of or information about the exception.
   */
  public NestableException(String msg) {
    super(msg);
  }

  /**
   * Constructs an exception with the given message and exception as
   * a root cause.
   * @param msg Description of or information about the exception.
   * @param cause Throwable that might have caused this one.
   */
  public NestableException(String msg, Throwable cause) {
    super(msg);
    this.cause = cause;
  }

  /**
   * Constructs an exception with the given exception as a root cause.
   * @param cause Exception that might have caused this one.
   */
  public NestableException(Throwable cause) {
    super(cause.toString());
    this.cause = cause;
  }

  /**
   * Returns the nested exception.
   */
  public Throwable getException() {
    return cause;
  }

  // Override stack trace methods to show original cause:
  public void printStackTrace() {
    printStackTrace(System.err);
  }

  public void printStackTrace(PrintStream ps) {
    synchronized (ps) {
      super.printStackTrace(ps);
      if (cause != null) {
        ps.println("--- Nested Exception ---");
        cause.printStackTrace(ps);
      }
    }
  }

  public void printStackTrace(PrintWriter pw) {
    synchronized (pw) {
      super.printStackTrace(pw);
      if (cause != null) {
        pw.println("--- Nested Exception ---");
        cause.printStackTrace(pw);
      }
    }
  }
}
