/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/exceptions/BadTreeException.java#2 $
 */

package com.sap.tc.jtools.jtci.exceptions;

/**
 * Exception thrown when attempting to construct a Persistable object
 * from an unsuitable StructureTree.
 *
 */

public class BadTreeException extends NestableException {
    public final String fToken;
    
    public BadTreeException(Exception e) {
        super(e);	
        fToken = null;
    }
    
    public BadTreeException() {
      super();
      fToken = null;
    }
    
    public BadTreeException(String info) {
      super(info);
      fToken = null;
    }
    
    public BadTreeException(String info, String token) {
      super (info);
      fToken = token;
    }
}