/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/cache/CacheEntry.java#2 $
 */

package com.sap.tc.jtools.jtci.cache;

import com.sap.tc.jtools.util.cache.CacheDependency;
import com.sap.tc.jtools.util.cache.Cacheable;

public class CacheEntry implements Cacheable {

	private String key;
	private CacheDependency[] dependencies;
	private long timestamp;
	private Object contents;

	public CacheEntry(
		String key,
		Object contents,
		CacheDependency[] dependencies,
		long timestamp) {
		this.key = key;
		this.dependencies = dependencies;
		this.timestamp = timestamp;
		this.contents = contents;
	}

	public String getKey() {
		return key;
	}

	public CacheDependency[] getDependencies() {
		return dependencies;
	}

	public long getTimeStamp() {
		return timestamp;
	}

	public Object getContents() {
		return contents;
	}

}