/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/cache/Cache.java#2 $
 */

package com.sap.tc.jtools.jtci.cache;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import com.sap.tc.jtools.util.cache.CacheDependency;
import com.sap.tc.jtools.util.cache.CacheException;
import com.sap.tc.jtools.util.cache.CacheInterface;
import com.sap.tc.jtools.util.cache.Cacheable;

public class Cache implements CacheInterface {

	private Map key2Object = new HashMap();
	private Map key2RegistryEntry = new HashMap();

	public Cache() {
	}

	private boolean isUpToDate(String key) {
		RegistryEntry registryEntry =
			(RegistryEntry) key2RegistryEntry.get(key);
		if (registryEntry == null)
			return false;
		long timestamp = registryEntry.getTimeStamp();
 
		CacheDependency[] preconditions = registryEntry.getDependencies();
		for (int j = 0; j < preconditions.length; j++) {
			System.out.println("checking precondition n." + j + ":"); 
			long pcTimestamp;
			if ( preconditions[j].isFile()) {
				File file = new File(preconditions[j].getKey());
				if ( !file.exists() )
					return false;
				pcTimestamp = file.lastModified();
			} else {
				pcTimestamp = ((RegistryEntry) key2RegistryEntry.get(preconditions[j].getKey()))
				.getTimeStamp();
			}
			if (!(timestamp > pcTimestamp))
				return false;
			if (!preconditions[j].isFile() &&!isUpToDate(preconditions[j].getKey()))
				return false;
		}
		return true;
	}

	public void addEntry(Cacheable newEntry) throws CacheException {
		System.out.println("adding entry " + newEntry.getKey());
		// is there an entry with same key already?
		RegistryEntry registryEntry =
			(RegistryEntry) key2RegistryEntry.get(newEntry.getKey());
		if (registryEntry == null) {
			// create new entry
			System.out.println("creating entry " + newEntry.getKey());
		} else {
			System.out.println("updating entry " + newEntry.getKey());
			// update old one
		}
		registryEntry =
			new RegistryEntry(
				newEntry.getKey(),
				newEntry.getDependencies(),
				newEntry.getTimeStamp());
		key2RegistryEntry.put(newEntry.getKey(), registryEntry);
		// add to cache
		key2Object.put(newEntry.getKey(), newEntry.getContents());
	}

	public Object getEntryValue(String entryName) {
		System.out.println("getting entry value" + entryName);
		if (!isUpToDate(entryName)) {
			System.out.println("entry " + entryName + " is not up to date");
			return null;
		}
		System.out.println("entry " + entryName + " is up to date");
		RegistryEntry entry = (RegistryEntry) key2RegistryEntry.get(entryName);
		return key2Object.get(entryName);
	}

 

}