/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/TestTree.java#2 $
 */

package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jlint.TestDefinition;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.*;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

import java.util.*;

/**
 * @author d034036
 */

public class TestTree implements TestTreeNode {

  private static final String TAG_TEST_TREE = "TESTS"; //$NON-NLS-1$
  private static final String PARAMETER_TEST_CATEGORY_NAME = "CATEGORY"; //$NON-NLS-1$
  private static final String PARAMETER_RESOURCE_BUNDLE = "RESOURCE_BUNDLE"; //$NON-NLS-1$

  private Vector nodes = new Vector(); //vector of TestTreeNode
  private String name = null;
  private String resourceBundle;

  public TestTree() {
  }

  public TestTree(StructureTree sTree) throws BadTreeException {
    String category = sTree.getParameter(PARAMETER_TEST_CATEGORY_NAME);
    if (category != null) {
      name = category;
    }
    resourceBundle = sTree.getParameter(PARAMETER_RESOURCE_BUNDLE);
    StructureTree[] children = sTree.getChildren();
    for (int i = 0; i < children.length; i++) {
      if (children[i].getTag().equals(TAG_TEST_TREE)) {
        nodes.add(new TestTree(children[i]));
      } else {
        nodes.add(new TestDefinition(children[i]));
      }
    }

  }

  public int getNodeType() {
    return TestTreeNode.TREE;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getName() {
    return name != null ? name : "";
  }

  public String getResourceBundle() {
    return resourceBundle;
  }

  public void setResourceBundle(String resourceBundle) {
    this.resourceBundle = resourceBundle;
  }

  public void addTree(TestTreeNode tree) {

    boolean found = false;
    for (Iterator iter = nodes.iterator(); iter.hasNext() && !found;) {
      TestTreeNode element = (TestTreeNode) iter.next();
      if (tree.getNodeType() != element.getNodeType()) {
        continue;
      }
      if (tree.getNodeType() == TestTreeNode.TEST) {
        //comparing two tests
        if (((TestDescriptionInterface) tree)
          .getName()
          .equals(((TestDescriptionInterface) element).getName())) {
          found = true; //test already there -> ignore
        }
      } else {
        if (((TestTree) tree)
          .getName()
          .equals(((TestTree) element).getName())) {
          TestTreeNode[] children = ((TestTree) tree).getNodes();
          for (int i = 0; i < children.length; i++) {
            ((TestTree) element).addTree(children[i]);
          }

          found = true;
        }
      }

    }
    if (!found) {
      nodes.add(tree);
    }

  }

  public TestTreeNode[] getNodes() {
    return (TestTreeNode[]) nodes.toArray(new TestTreeNode[nodes.size()]);
  }

  public TestDescriptionInterface[] getAllLeaves() {
    Vector allLeaves = getLeafVector();
    return (TestDescriptionInterface[]) allLeaves.toArray(
      new TestDescriptionInterface[allLeaves.size()]);
  }

  public StructureTree toStructureTree() {
    Header header = new Header(TAG_TEST_TREE);
    if (name != null) {
      header.setParameter(PARAMETER_TEST_CATEGORY_NAME, name);
    }
    if (resourceBundle != null) {
      header.setParameter(PARAMETER_RESOURCE_BUNDLE, resourceBundle);
    }
    StructureTree out = new StructureTree(header);
    for (Iterator iter = nodes.iterator(); iter.hasNext();) {
      TestTreeNode element = (TestTreeNode) iter.next();
      out.addNewChild(element.toStructureTree());
    }
    return out;

  }

  private Vector getLeafVector() {
    Vector allTests = new Vector();
    TestTreeNode[] nodes = getNodes();
    for (int i = 0; i < nodes.length; i++) {
      if (nodes[i].getNodeType() == TestTreeNode.TEST) {
        allTests.add(nodes[i]);
      } else {
        allTests.addAll(((TestTree) nodes[i]).getLeafVector());
      }
    }
    return allTests;
  }

}
