/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/TestSet.java#2 $
 */

package com.sap.tc.jtools.jtci;

 
import java.util.Iterator;
import java.util.Vector;

import com.sap.tc.jtools.util.persistable.*;
import com.sap.tc.jtools.util.structures.*;
import com.sap.tc.jtools.jtci.interfaces.*;
import com.sap.tc.jtools.jtci.exceptions.*;

public class TestSet implements Persistable {

  private String name;
  private Vector tests = new Vector();

  public static final String NAME_TAG = "NAME"; //$NON-NLS-1$
  private static final String PARAMETER_TAG_TEST_SET = "TEST_SET"; //$NON-NLS-1$
   
  public TestSet(String name) {
    this.name = name;
  }

  public TestSet(String name, Test[] tests) {
    this.name = name;
    for (int i = 0; i < tests.length; i++) {
      this.tests.add(tests[i]);
    }
  }

  public TestSet(StructureTree tree) throws BadTreeException {
    this.name = tree.getParameter(NAME_TAG);
    StructureTree[] singleTestTrees =
      tree.getChildren(TestDescriptionInterface.PARAMETER_TAG_TEST);
    for (int i = 0; i < singleTestTrees.length; i++) {
      tests.add(new Test(singleTestTrees[i]));
    }
  }

  public void addTest(Test test) {
    tests.add(test);
  }

  public void removeTest(Test test) {
    tests.remove(test);
  }

  public StructureTree toStructureTree() {
    Header header = new Header(PARAMETER_TAG_TEST_SET);
    header.setParameter(NAME_TAG, name);
    StructureTree rootTree = new StructureTree(header);
    for (Iterator iter = tests.iterator(); iter.hasNext();) {
      Test test = (Test) iter.next();
      rootTree.addNewChild(test.toStructureTree());
    }
    return rootTree;
  }

  public Test[] getTests() {
    return (Test[]) tests.toArray(new Test[tests.size()]);
  }

  public Test[] getActiveTests() {
    Vector activeTests = new Vector();
    for (Iterator iter = tests.iterator(); iter.hasNext();) {
      Test test = (Test) iter.next();
      if (test.isActive()) {
        activeTests.add(test);
      }
    }
    return (Test[]) activeTests.toArray(new Test[activeTests.size()]);
  }

  public Test getTest(String name) {
    for (Iterator iter = tests.iterator(); iter.hasNext();) {
      Test test = (Test) iter.next();
      if (test.getName().equals(name)) {
        return test;
      }
    }
    return null;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

}