/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/TestObject.java#3 $
 */

package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.StructureTree;

/**
 * represents a test object. The specific test object type is determined by the 
 * concrete subclass.
 * <p>
 * Test objects are identified by the following parameters:
 * <ul>
 * <li>type (String)</li>
 * <li>ID (String)</li>
 * </ul>
 * 
 * <p>The object value can be of any type</p>
 * 
 * <p>
 * Copyright (c) 2003, SAP AG
 * 
 */

abstract public class TestObject implements Persistable {

	/**
	 * returns the test object type.
	 * 
	 * @return object type
	 * 
	 */
	abstract public String getType();

	/**
	 * returns the test object ID.
	 * 
	 * @return object ID
	 * 
	 */
	abstract public String getID();

	abstract public int getComponentCount();

	abstract public String[] getCodeClassification();
	
	public static TestObjectPosition getPosition(StructureTree tree) {
		try {
			return new FilePosition(tree);
		} catch (Exception e) {
			return null;
		}
	}

	/* XML representation */
	protected final static String TAG_TEST_OBJECT = "TEST_OBJECT"; //$NON-NLS-1$
	protected final static String PARAMETER_ID = "ID"; //$NON-NLS-1$
	public final static String TEST_OBJECT = "TEST_OBJECT"; //$NON-NLS-1$


}