/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/TestMessageDescription.java#3 $
 */

package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;


/**
 * @author D037913
 */
public class TestMessageDescription implements ITestMessageDescription {

  private String key;
  private String displayName;
  private int prio;

  public TestMessageDescription(String key, String displayName, int prio) {
    this.key = key;
    this.displayName = displayName;
    this.prio = prio;
  }

  public static TestMessageDescription fromStructureTree(StructureTree tree) {
    if (!TAG_MESSAGE.equals(tree.getTag()))
      throw new IllegalArgumentException();
    String prioString = tree.getParameter(TAG_PRIO).trim();
    int prio;
    if (ATTR_DYNAMIC_PRIO.equalsIgnoreCase(prioString))
      prio = PRIO_DYNAMIC;
    else
      prio = Integer.parseInt(prioString);
    return new TestMessageDescription(
      tree.getParameter(TAG_KEY),
      tree.getParameter(TAG_DISPLAY_NAME),
      prio);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription#getKey()
   */
  public String getKey() {
    return key;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription#getPriority()
   */
  public int getPriority() {
    return prio;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription#getDisplayName()
   */
  public String getDisplayName() {
    return displayName != null ? displayName : key;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.util.persistable.Persistable#toStructureTree()
   */
  public StructureTree toStructureTree() {
    Header msgHeader = new Header(TAG_MESSAGE);
    msgHeader.setParameter(TAG_KEY, key);
    msgHeader.setParameter(
      TAG_PRIO,
      prio == PRIO_DYNAMIC ? ATTR_DYNAMIC_PRIO : String.valueOf(prio));
    if (displayName != null) {
      msgHeader.setParameter(TAG_DISPLAY_NAME, displayName);
    }
    return new StructureTree(msgHeader);
  }

}
