/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/PerformUnit.java#3 $
 */

package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.interfaces.*;

/**
 * PerformRequest subunit. It contains a set of tests (name + parameters)
 * and a set of targets (objects to be tested). The semantics is that
 * all tests will be performed on all targets.
 *
 * <p>
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author
 * @version 1.0
 */

public class PerformUnit {
	private TestObject[] sources = new TestObject[0];
	private Test[] tests = new Test[0];

	/**
	 * constructor
	 * 
	 * @param sources sources to be tested
	 * @param tests tests to be performed
	 */
	public PerformUnit(TestObject[] sources, Test[] tests) {
		this.sources = sources;
		this.tests = tests;
	}

	/**
	 * parameterless constructor
	 *
	 */
	public PerformUnit() {
	}

	/**
	 * Adds test target to perform unit.
	 * @param newSource target to be added.
	 *
	 */
	public void addSource(TestObject newSource) {
		TestObject[] tempArray = new TestObject[sources.length + 1];
		for (int i = 0; i < sources.length; i++) {
			tempArray[i] = sources[i];
		}
		tempArray[sources.length] = newSource;
		sources = tempArray;
	}

	/**
	 * Adds test (name + parameters) to perform unit.
	 * @param newTest test to be added.
	 *
	 */
	public void addTest(Test newTest) {
		Test[] tempArray = new Test[tests.length + 1];
		for (int i = 0; i < tests.length; i++) {
			tempArray[i] = tests[i];
		}
		tempArray[tests.length] = newTest;
		tests = tempArray;
	}

	/**
	 * Returns source list.
	 */
	public TestObject[] getSources() {
		return sources;
	}

	/**
	 * Returns test list.
	 */
	public Test[] getTests() {
		return tests;
	}
}