/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/IntParameter.java#2 $
 */

package com.sap.tc.jtools.jtci;

import java.io.Serializable;

import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

/**
 * TODO: description of this class/interface 
 * @author D037913
 */
public class IntParameter implements ParameterInterface {

  private String name;
  private int value;

  public IntParameter(String name, int value) {
    this.name = name;
    this.value = value;
  }

  public IntParameter(String name, String value) {
    this.name = name;
    if (value != null) {
      try {
        this.value = Integer.parseInt(value.trim());
      } catch (NumberFormatException e) {
        //$JL-EXC$ default value is 0
      }
    }
  }

  static IntParameter createFromStructureTree(StructureTree tree)
    throws BadTreeException {
    Header header = tree.getHeader();
    String type = header.getParameter(PARAMETER_TYPE);
    String name = header.getParameter(PARAMETER_NAME);
    if (type == null
      || name == null | !ParameterTool.PAR_TYPE_INT.equals(type)) {
      throw new BadTreeException();
    }
    StructureTree contents[] = tree.getChildren(PARAMETER_VALUE);
    if (null == contents || contents.length == 0)
      return new IntParameter(name, 0);
    if (1 != contents.length) {
      throw new BadTreeException("illegal value content"); //$NON-NLS-1$
    }
    String valueString = contents[0].getText();
    if (valueString == null) {
      throw new BadTreeException();
    }
    int value;
    try {
      value = Integer.parseInt(valueString);
    } catch (NumberFormatException e) {
      throw new BadTreeException(e);
    }
    return new IntParameter(name, value);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jtci.interfaces.ParameterInterface#getName()
   */
  public String getName() {
    return name;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jtci.interfaces.ParameterInterface#getType()
   */
  public String getType() {
    return ParameterTool.PAR_TYPE_INT;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jtci.interfaces.ParameterInterface#getValue()
   */
  public Serializable getValue() {
    return new Integer(value);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jtci.interfaces.ParameterInterface#setValue(java.io.Serializable)
   */
  public void setValue(Serializable value) {
    if (!(value instanceof Integer))
      throw new IllegalArgumentException();
    this.value = ((Integer) value).intValue();
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jtci.interfaces.ParameterInterface#valueToString()
   */
  public String valueToString() {
    return String.valueOf(value);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.util.persistable.Persistable#toStructureTree()
   */
  public StructureTree toStructureTree() {
    Header paramHeader = new Header(INPUT_PARAMETER_TAG);
    paramHeader.setParameter(PARAMETER_NAME, name);
    paramHeader.setParameter(PARAMETER_TYPE, ParameterTool.PAR_TYPE_INT);

    StructureTree paramTree = new StructureTree(paramHeader);
    Header contentHeader = new Header(PARAMETER_VALUE);
    StructureTree contentTree = new StructureTree(contentHeader);
    paramTree.addNewChild(contentTree);
    contentTree.setText(valueToString());
    return paramTree;
  }

}
