/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/FilePosition.java#2 $
 */

 
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

 
/**
 * represents a position within a file set.
 * 
 * A position is specified by the following parameters:
 * <ul>
 * <li>file</li>
 * <li>line</li>
 * <li>column</li>
 * </ul>
 * 
 * A file as a whole are represented by assigning line and column the conventional values (-1,-1).
 *
 */
public class FilePosition implements TestObjectPosition {

	/* XML representation */
	private final static String TAG_FILE = "FILE"; //$NON-NLS-1$
	private final static String TAG_FILE_POSITION = "FILE_POSITION"; //$NON-NLS-1$
	private final static String PARAMETER_LINE = "LINE"; //$NON-NLS-1$    
	private final static String PARAMETER_COLUMN = "COLUMN"; //$NON-NLS-1$    
	private final static int DEFAULT_LINE = -1;
	private final static int DEFAULT_COLUMN = -1;

	private String file;
	public int line = DEFAULT_LINE;
	public int column = DEFAULT_COLUMN;

	public FilePosition(String file, int line, int column) {
		this.file = file;
		this.line = line;
		this.column = column;
	}
	public FilePosition(String file) {
		this.file = file;
	}

	public String getFile() {
		return file;
	}
	public int getLine() {
		return line;
	}
	public int getColumn() {
		return column;
	}

	public StructureTree toStructureTree() {
		Header fileHeader = new Header("FILE");
		fileHeader.setParameter("NAME", getFile());
		StructureTree fileTree = new StructureTree(fileHeader);
		int line = getLine();
		int column = getColumn();
		if (line != -1 || column != -1) {
			Header filePositionHeader = new Header("FILE_POSITION");
			if (line != -1)
				filePositionHeader.setParameter(
					"LINE",
					Integer.toString(line));
			if (column != -1)
				filePositionHeader.setParameter(
					"COLUMN",
					Integer.toString(column));
			StructureTree filePositionTree =
				new StructureTree(filePositionHeader);
			fileTree.addChild(filePositionTree);
		}
		return fileTree;
	}
	
	public FilePosition (StructureTree tree) throws BadTreeException {
		 String tag = tree.getTag();
		 if (!tag.equals("FILE")) {
			throw new BadTreeException();
		 }
		 file = tree.getParameter("NAME");
		 StructureTree filePosition = tree.getOnlyChild("FILE_POSITION");
		 if ( filePosition != null ) {
			String lineString = filePosition.getParameter("LINE");
			String columnString = filePosition.getParameter("COLUMN");
			line = lineString == null ? -1 : Integer.parseInt(lineString);
			column = columnString == null ? -1 : Integer.parseInt(columnString);
		 }
	}
		 
}
