/*
 * Copyright (c) 2004 by SAP AG, Walldorf.
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jtci/CodeClassificationConstants.java#3 $
 */
 
package com.sap.tc.jtools.jtci;

/**
 * @author D034036
 *
 */
public class CodeClassificationConstants {
	public final static String PRODUCTIVE_CODE_STR = "productive";
	public final static String TEST_CODE_STR = "test";
	public final static String GENERATED_CODE_STR = "generated";
	public final static String IDE_CODE_STR = "ide";
	public final static String J2EE_ENGINE_CODE_STR = "j2ee_engine";
  public final static String J2EE_ENGINE_SERVICE_CODE_STR = "engine_service";
  public final static String J2EE_ENGINE_LIBRARY_CODE_STR = "engine_library";
	public final static String CORE_TECHNOLOGY_CODE_STR = "core_technology";
	public final static String GUI_CODE_STR = "gui";
	public final static String J2EE_APPLICATION_CODE_STR = "j2ee_application";
	public final static String API_CODE_STR = "api";
	public final static String WD_CODE_STR = "webdynpro";
	public final static String ALL_CODE_STR = "all";

	
	/* used internally */
	public static long getValue(String codeType) {
		if ( codeType.equals(PRODUCTIVE_CODE_STR) ) {
			return 0x1;
		}
		if ( codeType.equals(TEST_CODE_STR) ) {
			return 0x2;
		}
		if ( codeType.equals(GENERATED_CODE_STR) ) {
			return 0x4;
		}
		if ( codeType.equals(IDE_CODE_STR) ) {
			return 0x8;
		}
		if ( codeType.equals(J2EE_ENGINE_CODE_STR) ) {
			return 0x10;
		}
		if ( codeType.equals(CORE_TECHNOLOGY_CODE_STR) ) {
			return 0x20;
		}
		if ( codeType.equals(GUI_CODE_STR) ) {
			return 0x40;
		}
		if ( codeType.equals(J2EE_APPLICATION_CODE_STR) ) {
			return 0x80;
		}
		if (codeType.equals(API_CODE_STR)) {
			return 0x100;
		}
		if (codeType.equals(WD_CODE_STR)) {
			return 0x200;
		}
    if (codeType.equals(J2EE_ENGINE_LIBRARY_CODE_STR)) {
      return 0x400;
    }
    if (codeType.equals(J2EE_ENGINE_SERVICE_CODE_STR)) {
      return 0x800;
    }
		if (codeType.equals(ALL_CODE_STR)) {
			return Long.MAX_VALUE;
		}
		return 0;
	}

	public static long getValue(String[] codeClassification) {
		long out = 0;
		for (int i = 0; i < codeClassification.length; i++) {
			out |= CodeClassificationConstants.getValue(codeClassification[i]);
		}
		return out;
	}
	

}
