/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/statistics/ResultStatistics.java#2 $
 */

package com.sap.tc.jtools.jlint.statistics;

import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

/**
 * @author SAP AG d034036
 *
 */
public class ResultStatistics implements Persistable {

	private MetricSummary metricResults;
	private TestSummary testSummary;

	public ResultStatistics(StructureTree tree) {
		metricResults = new MetricSummary(tree.getOnlyChild("METRICS"));
		testSummary = new TestSummary(tree.getOnlyChild("TESTS"));
	}
	public ResultStatistics(ResultInterface[] results) {
		testSummary = new TestSummary(results);
		metricResults = new MetricSummary(results);
	}

	public ResultStatistics(TestSummary ts, MetricSummary ms) {
		testSummary = ts;
		metricResults = ms;
	}

	public MetricSummary getMetricResult() {
		return metricResults;
	}

	public TestSummary getTestSummary() {
		return testSummary;
	}

	public static ResultStatistics merge(ResultStatistics[] toBeAdded) {
		TestSummary[] tss = new TestSummary[toBeAdded.length];
		MetricSummary[] mss = new MetricSummary[toBeAdded.length];
		for (int i = 0; i < toBeAdded.length; i++) {
			tss[i] = toBeAdded[i].testSummary;
			mss[i] = toBeAdded[i].metricResults;
		}
		return new ResultStatistics(TestSummary.merge(tss),MetricSummary.merge(mss));
	}

	public StructureTree toStructureTree() {
		StructureTree tree = new StructureTree(new Header("STATISTICS"));
		tree.addChild(metricResults.toStructureTree());
		tree.addChild(testSummary.toStructureTree());
		return tree;
	}

}
