/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/statistics/MetricSummary.java#2 $
 */

package com.sap.tc.jtools.jlint.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

/**
 * @author SAP AG d034036
 *
 */
public class MetricSummary implements Persistable {
 

	private MetricResult[] metricResults;

	public MetricSummary(StructureTree tree) {
		StructureTree[] children = tree.getChildren("METRIC_RESULT");
		metricResults = new MetricResult[children.length];
		for (int i = 0; i < children.length; i++) {
			metricResults[i] = new MetricResult(children[i]);
		}
	}
	
	public MetricSummary(ResultInterface[] results) {
		List metricResultList = new ArrayList();
		for (int i = 0; i < results.length; i++) {
			if (MetricResult.isGlobalMetricResult(results[i]) 
				&& results[i].getPriority() <= Result.SEVERITY_INFO
			&& results[i].getPriority() >= Result.SEVERITY_ERROR) {
				MetricResult mr = new MetricResult(results[i]);
				metricResultList.add(mr);
			}
		}
		metricResults = (MetricResult[]) metricResultList.toArray(new MetricResult[0]);
	}

	public MetricSummary(MetricResult[] metricResults) {
		this.metricResults = metricResults;
	}
	
	public MetricResult[] getMetricResults() {
		return metricResults;
	}

	public static MetricSummary merge(MetricSummary[] toBeAdded) {
		Map name2results = new HashMap();
		for (int i = 0; i < toBeAdded.length; i++) {
			MetricResult[] mResults = toBeAdded[i].getMetricResults();
			for (int j = 0; j < mResults.length; j++) {
				String mName = mResults[j].getTestName()+"$$"+mResults[j].getMetricName();
				List mList = (List) name2results.get(mName);
				if (mList == null) {
					mList = new ArrayList();
					name2results.put(mName, mList);
				}
				mList.add(mResults[j]);
			}
		}
		List mergedMetricList = new ArrayList();
		for (Iterator iter = name2results.values().iterator(); iter.hasNext();) {
			List mList = (List) iter.next();
			mergedMetricList.add(MetricResult.merge((MetricResult[]) mList.toArray(new MetricResult[0])));
		}
		MetricResult[] mergedResults = (MetricResult[]) mergedMetricList.toArray(new MetricResult[0]);
		return new MetricSummary(mergedResults);
	}

	public StructureTree toStructureTree() {
		StructureTree tree = new StructureTree(new Header("METRICS"));
		for (int i = 0; i < metricResults.length; i++) {
			tree.addChild(metricResults[i].toStructureTree());
		}
		return tree;
	}

}
