/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/VariantPage.java#2 $
 */

package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;

/**
 * @author SAP AG d034036
 *
 */
public class VariantPage extends Page {

 
	private TestSet data;
	private String contents;

	/**
	 * @param tests
	 */
	public VariantPage(TestSet tests, String address,RunReportPageManager manager) {
		super(address,manager);
		this.data = tests;
	}

	public String getContents() {
		if (contents == null) {
			StringBuffer sb = new StringBuffer(PAGE_HEADER_START);
			sb.append("Test variant " + data.getName());
			sb.append(PAGE_HEADER_END);
			sb.append("<body style=\"font-family: arial;\"><h2>");
			sb.append("Test variant " + data.getName());
			sb.append("</h2>");
			sb.append("<hr><p>");

			Test[] tests = data.getActiveTests();
			for (int i = 0; i < tests.length; i++) {
				Test test = tests[i];
				String name = test.getName();
				sb.append("<li><b>"+name+"</b>");
				ParameterInterface[] parameters = test.getParameters();
				for (int j = 0; j < parameters.length; j++) {
					ParameterInterface parameter = parameters[j];
					String parName = parameter.getName();
					String parValue = parameter.valueToString();
					sb.append("<p>"+parName+":"+parValue+"</p>"); 
				}
			}
 
			sb.append("</body></html>");
			contents = sb.toString();
		}
		return contents;

	}

 

}
