/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/TestDescriptionPage.java#3 $
 */

package com.sap.tc.jtools.jlint.report.html;

import java.io.Serializable;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.TestTreeNode;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;

/**
 * @author SAP AG d034036
 *
 */
public class TestDescriptionPage extends Page {

  private TestDescriptionSet data;
  private String contents;
  /**
   * @param tests
   */
  public TestDescriptionPage(
    TestDescriptionSet tests,
    String address,
    RunReportPageManager manager) {
    super(address, manager);
    this.data = tests;
  }

  public String getContents() {
    if (contents == null) {
      StringBuffer sb = new StringBuffer(PAGE_HEADER_START);
      sb.append(
        "Test set " + data.getName() + " (version " + data.getVersion() + ")");
      sb.append(PAGE_HEADER_END);
      sb.append("<body style=\"font-family: arial;\"><h2>");
      sb.append(
        "Test set " + data.getName() + " (version " + data.getVersion() + ")");
      sb.append("</h2>");
      sb.append("<hr><p>");

      sb.append(
        "<table border=\"1\"><tr><th>Category</th><th>Testname</th><th>Responsible</th>"
          + ""
          + "<th>Version</th><th>Description</th></tr>");
      TestTree topTree = data.getTestTree();
      sb.append(getTableContent(topTree, ""));
      sb.append("</table>");
      sb.append(getDescriptionContent(topTree, ""));
      sb.append("</body></html>");
      contents = sb.toString();
    }
    return contents;

  }

  private String getDescriptionContent(TestTree tree, String parentCategory) {
    StringBuffer sb = new StringBuffer();
    String category = parentCategory + "/" + tree.getName();
    TestTreeNode[] nodes = tree.getNodes();
    for (int i = 0; i < nodes.length; i++) {
      switch (nodes[i].getNodeType()) {
        case TestTreeNode.TREE :
          sb.append(getDescriptionContent((TestTree) nodes[i], category));
          break;
        case TestTreeNode.TEST :
          sb.append(
            getTestDescriptionContent(
              (TestDescriptionInterface) nodes[i],
              category));
      }
    }
    return sb.toString();
  }

  private String getTestDescriptionContent(
    TestDescriptionInterface test,
    String category) {
    StringBuffer sb = new StringBuffer();
    sb.append(
      "<h3><a name=\"" + test.getName() + "\"></a>" + test.getName() + "</h3>");
    sb.append("<dl>");
    sb.append("<dt>Responsible</dt>");
    sb.append("<dd>" + test.getTestResponsible() + "</dd><p>");
    sb.append("<dt>Version</dt>");
    sb.append("<dd>" + test.getVersion() + "</dd><p>");
    sb.append("<dt>Description</dt>");
    sb.append("<dd><pre>" + test.getDescription() + "</pre></dd>");
    String pseudoComment = getPseudoComment(test);
    sb.append("<dt>Disabling Pseudocomment</dt>");
    if (pseudoComment != null) {
      sb.append("<dd>This test may be disabled using the pseudo-comment <tt>" + pseudoComment + "</tt></dd><p>");
    } else {
      sb.append("<dd>None</dd><p>");
    }
    sb.append("<dt>Messages</dt>");
    sb.append("<dd><p>");
    ITestMessageDescription[] messages = test.getMessages();
    if (messages.length == 0) {
      sb.append("none");
    } else {
      sb.append("<table border=\"1\"><tr><th>Message</th><th>Prio</th></tr>");

      for (int i = 0; i < messages.length; i++) {
        sb.append("<tr><td>" + messages[i].getDisplayName() + "</td>");
        int prio = messages[i].getPriority();
        sb.append(
          "<td>"
            + (prio == ITestMessageDescription.PRIO_DYNAMIC
              ? "dynamic"
              : Integer.toString(prio))
            + "</td></tr>");
      }
      sb.append("</table>");
    }
    sb.append("<dd>");

    sb.append("<p><dt>Parameters</dt>");
    ParameterInterface[] params = test.getInputParameters();
    sb.append("<dd><p>");
    if (params.length == 0) {
      sb.append("none");
    } else {
      sb.append(
        "<table border=\"1\"><tr><th>Name</th><th>Type</th><th>Default value</th></tr>");
      for (int i = 0; i < params.length; i++) {
        sb.append("<tr><td>" + params[i].getName() + "</td>");
        sb.append("<td>" + params[i].getType() + "</td>");
        Serializable value = params[i].getValue();
        sb.append(
          "<td>" + (value == null ? "" : value.toString()) + "</td></tr>");
      }
      sb.append("</table>");
    }
    sb.append("</dd></dl><p><p>");
    return sb.toString();
  }

  private static String getPseudoComment(TestDescriptionInterface test) {
    ParameterInterface pseudoComment = test.getInternalParameter("PSEUDO_COMMENT_SUFFIX");
    if (pseudoComment != null) {
      return "//$JL-" + ((String) pseudoComment.getValue()).trim().toUpperCase() + "$";
    } else {
      return null;
    }
  }

  private String getTableContent(TestTree tree, String parentCategory) {
    StringBuffer sb = new StringBuffer();
    String category = parentCategory + "/" + tree.getName();
    TestTreeNode[] nodes = tree.getNodes();
    for (int i = 0; i < nodes.length; i++) {
      switch (nodes[i].getNodeType()) {
        case TestTreeNode.TREE :
          sb.append(getTableContent((TestTree) nodes[i], category));
          break;
        case TestTreeNode.TEST :
          sb.append(
            getTestContent((TestDescriptionInterface) nodes[i], category));
      }
    }

    return sb.toString();
  }

  private String getTestContent(
    TestDescriptionInterface test,
    String category) {
    StringBuffer sb = new StringBuffer();
    sb.append("<tr><td>" + category + "</td>");
    sb.append("<td>" + test.getName() + "</td>");
    sb.append("<td>" + test.getTestResponsible() + "</td>");
    sb.append("<td>" + test.getVersion() + "</td>");
    sb.append("<td><a href=\"#" + test.getName() + "\">Description</a></td>");
    sb.append("</tr>");
    return sb.toString();
  }

}
